/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class MQEventDao
extends AbstractIdDao<MQEvent> {
    public MQEventDao(Connection con) {
        super(con, 0, "publish_event");
    }

    public SearchResult<MQEvent> searchMQEventList(Page page) throws BGException {
        SearchResult<MQEvent> searchResult = new SearchResult<MQEvent>(page);
        searchResult.setList(this.list("", "title", new Object[0]));
        return searchResult;
    }

    @Override
    protected MQEvent getFromRS(ResultSet rs) throws SQLException, BGException {
        MQEvent mqEvent = new MQEvent();
        mqEvent.setId(rs.getInt("id"));
        mqEvent.setTitle(rs.getString("title"));
        String data = rs.getString("data");
        if (data == null || data.isEmpty()) {
            data = "{}";
        }
        mqEvent.setData(data);
        return mqEvent;
    }

    @Override
    protected void updateImpl(MQEvent mqEvent) throws BGException, SQLException {
        if (mqEvent == null) {
            throw new BGException("mqEvent is null!!!");
        }
        boolean insert = mqEvent.getId() <= 0;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET title=?, data=?" + (insert ? "" : " WHERE id=?");
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        JSONObject jsonObject = mqEvent.toJson();
        int index = 1;
        ps.setString(index++, mqEvent.getTitle());
        ps.setString(index++, jsonObject.toString());
        if (!insert) {
            ps.setInt(index++, mqEvent.getId());
        }
        ps.executeUpdate();
        if (insert) {
            mqEvent.setId(ServerUtils.lastInsertId((Connection)this.con));
        }
        ps.close();
    }
}

