/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.server;

import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQEvent;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQServer;
import ru.bitel.bgbilling.kernel.event.publish.server.bean.MQEventDao;
import ru.bitel.bgbilling.kernel.event.publish.server.bean.MQServerDao;
import ru.bitel.bgbilling.server.util.Setup;

public class MQEventProcessor {
    static final Logger logger = LogManager.getLogger();
    private static MQEventProcessor mqEventProcessor = null;
    private Map<String, MQEvent> mqEvents = new HashMap<String, MQEvent>();
    private Map<Integer, MQServer> mqServers = new HashMap<Integer, MQServer>();
    private Map<Integer, MQSession> mqSessions = new HashMap<Integer, MQSession>();

    public static final MQEventProcessor getInstance() {
        if (mqEventProcessor == null) {
            mqEventProcessor = new MQEventProcessor();
        }
        return mqEventProcessor;
    }

    private MQEventProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws BGException {
        Setup setup = Setup.getSetup();
        java.sql.Connection sqlConnection = setup.getDBConnectionFromPool();
        HashMap<Integer, MQServer> mqServers = new HashMap<Integer, MQServer>();
        try (MQServerDao mqServerDao = new MQServerDao(sqlConnection);){
            mqServerDao.searchMQServerList(null).getList().forEach(e -> mqServers.put(e.getId(), (MQServer)e));
        }
        HashMap<String, MQEvent> mqEvents = new HashMap<String, MQEvent>();
        try (MQEventDao mqEventDao = new MQEventDao(sqlConnection);){
            mqEventDao.searchMQEventList(null).getList().forEach(e -> mqEvents.put(e.getEvent(), (MQEvent)e));
        }
        MQEventProcessor mQEventProcessor = mqEventProcessor;
        synchronized (mQEventProcessor) {
            this.mqSessions.forEach((k, v) -> v.sessionStop());
            this.mqSessions = new HashMap<Integer, MQSession>();
            this.mqServers = mqServers;
            this.mqEvents = mqEvents;
        }
    }

    public void publish(Event event) throws BGException {
        if (event == null) {
            throw new BGException("Event is null!!!");
        }
        try {
            MQSession mqSession;
            MQEvent mqEvent = this.mqEvents.get(event.getClass().getName());
            if (mqEvent != null && (mqSession = this.getMQSession(this.mqServers.get(mqEvent.getMqServer()))) != null) {
                mqSession.addEvent(new EventItem(event, mqEvent));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private MQSession getMQSession(MQServer mqServer) {
        MQSession mqSession = this.mqSessions.get(mqServer.getId());
        if (mqSession == null) {
            mqSession = new MQSession(mqServer);
            this.mqSessions.put(mqServer.getId(), mqSession);
        }
        return mqSession;
    }

    class MQSession
    extends Thread {
        boolean stop = false;
        Session session = null;
        MQServer mqServer = null;
        Deque<EventItem> items = new LinkedList<EventItem>();

        MQSession(MQServer mqServer) {
            this.mqServer = mqServer;
            try {
                this.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public synchronized void run() {
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("connectionfactory.url", this.mqServer.getUrl());
                hashtable.put("java.naming.factory.initial", "org.apache.qpid.jms.jndi.JmsInitialContextFactory");
                InitialContext context = new InitialContext(hashtable);
                ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup("url");
                Connection connection = connectionFactory.createConnection(this.mqServer.getUserName(), this.mqServer.getUserPassword());
                this.session = connection.createSession(false, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            while (true) {
                if (this.items.isEmpty()) {
                    if (this.stop) break;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                EventItem eventItem = this.items.removeFirst();
                try {
                    TextMessage textMessage = this.session.createTextMessage(new JSONObject((Object)eventItem.event).toString());
                    MessageProducer messageProducer = this.session.createProducer((Destination)eventItem.mqEvent.getDestination());
                    messageProducer.send((Message)textMessage, eventItem.mqEvent.getDeliveryMode(), eventItem.mqEvent.getPriority(), eventItem.mqEvent.getTimeToLive());
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }

        synchronized void addEvent(EventItem eventItem) {
            this.items.addLast(eventItem);
            this.notify();
        }

        synchronized void sessionStop() {
            this.stop = true;
            this.notify();
        }
    }

    class EventItem {
        Event event = null;
        MQEvent mqEvent = null;

        public EventItem(Event event, MQEvent mqEvent) {
            this.event = event;
            this.mqEvent = mqEvent;
        }
    }
}

