/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server;

import bitel.billing.server.ApplicationModule;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.auth.ModuleAuth;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.common.extension.DefaultClassExtension;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.module.server.bean.ServiceDao;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.kernel.module.server.event.ServicesChangedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ModuleCache {
    private static final Logger log = LogManager.getLogger();
    private static final ModuleCache instance = new ModuleCache();
    private volatile List<BGInstalledModule> installedModules;
    private volatile Map<String, BGInstalledModule> installedModulesMap;
    private volatile Map<String, ApplicationModule> applicationModulesMap;
    private volatile Map<String, ModuleAuth> authModulesMap;
    private volatile Map<Integer, BGModule> moduleMap;
    private volatile List<BGModule> moduleListTitleSorted;
    private volatile List<BGModule> moduleListProcessOrderSorted;
    private volatile List<Service> serviceList;
    private volatile Map<Integer, List<Service>> moduleServicesMap;
    private volatile Map<Integer, String> moduleServicesStringMap;
    private volatile List<Service> usedServiceList;
    private volatile Map<Integer, List<Service>> moduleUsedServicesMap;
    private volatile Map<Integer, String> moduleUsedServicesStringMap;

    public static ModuleCache getInstance() {
        return instance;
    }

    private ModuleCache() {
        this.reloadModules();
        this.reloadServices();
        this.reloadUsedServices();
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModulesChangedEvent>(){

                @Override
                public void notify(ModulesChangedEvent e, EventListenerContext ctx) throws BGException {
                    ModuleCache.this.reloadModules();
                }
            }, ModulesChangedEvent.class);
            EventProcessor.getInstance().addListener(new EventListener<ServicesChangedEvent>(){

                @Override
                public void notify(ServicesChangedEvent e, EventListenerContext ctx) throws BGException {
                    ModuleCache.this.reloadServices();
                    ModuleCache.this.reloadUsedServices();
                }
            }, ServicesChangedEvent.class);
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<Element> extensionListForPoint(String point) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (point != null) {
            for (BGInstalledModule installedModule : this.installedModules) {
                Element extension = installedModule.getServerExtensionMap().get(point);
                if (extension == null) continue;
                list.add(extension);
            }
        }
        return list;
    }

    public static void removeModuleInstalledFlag(Connection con) {
        ServerUtils.removeSetupValue(con, "20");
    }

    public synchronized void reloadModules(Connection con) {
        try {
            ModuleManager mm = new ModuleManager(con);
            List<BGInstalledModule> installedModules = mm.getInstalledModules(ComponentType.MODULE, ComponentType.PLUGIN);
            HashMap<String, BGInstalledModule> installedModulesMap = new HashMap<String, BGInstalledModule>();
            Map<String, ApplicationModule> oldApplicationModulesMap = this.applicationModulesMap;
            HashMap<String, ApplicationModule> applicationModulesMap = new HashMap<String, ApplicationModule>();
            HashMap<String, ModuleAuth> authModulesMap = new HashMap<String, ModuleAuth>();
            for (BGInstalledModule iModule : installedModules) {
                String authClass;
                ModuleAuth moduleAuth;
                installedModulesMap.put(iModule.getName(), iModule);
                if (iModule.getType() != ComponentType.MODULE) continue;
                String moduleClass = iModule.getPackageServer() + ".Module";
                if (!applicationModulesMap.containsKey(iModule.getName())) {
                    ApplicationModule module;
                    ApplicationModule applicationModule = module = oldApplicationModulesMap != null ? oldApplicationModulesMap.get(iModule.getName()) : null;
                    if (module == null) {
                        module = (ApplicationModule)Utils.newInstance((String)moduleClass, ApplicationModule.class);
                    }
                    if (module != null) {
                        applicationModulesMap.put(iModule.getName(), module);
                    }
                }
                if ((moduleAuth = (ModuleAuth)Utils.newInstance((String)(authClass = iModule.getPackageServer() + ".ModuleAuthImpl"), ModuleAuth.class)) == null) continue;
                authModulesMap.put(iModule.getName(), moduleAuth);
            }
            this.installedModules = installedModules;
            this.installedModulesMap = installedModulesMap;
            this.applicationModulesMap = applicationModulesMap;
            this.authModulesMap = authModulesMap;
            Map<Integer, BGModule> moduleMap = mm.getModulesMap();
            List<BGModule> moduleListProcessOrderSorted = mm.getModules();
            List<BGModule> moduleListTitleSorted = mm.getModules(null);
            this.setInstalledModules(moduleMap.values());
            this.setInstalledModules(moduleListProcessOrderSorted);
            this.setInstalledModules(moduleListTitleSorted);
            this.moduleMap = moduleMap;
            this.moduleListProcessOrderSorted = moduleListProcessOrderSorted;
            this.moduleListTitleSorted = Collections.unmodifiableList(moduleListTitleSorted);
        }
        catch (Exception e) {
            log.error("error reload modules", (Throwable)e);
        }
    }

    private synchronized void reloadModules() {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            this.reloadModules(con);
        }
        catch (Exception e) {
            log.error("error reload modules", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reloadUsedServices() {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try (ServiceDao serviceDao = new ServiceDao(con);){
            HashMap<Integer, List<Service>> serviceMap = new HashMap<Integer, List<Service>>();
            HashMap<Integer, String> moduleSids = new HashMap<Integer, String>();
            List<Service> serviceList = serviceDao.listUsing();
            this.getServiceData(serviceList, serviceMap, moduleSids);
            this.usedServiceList = serviceList;
            this.moduleUsedServicesMap = serviceMap;
            this.moduleUsedServicesStringMap = moduleSids;
        }
        catch (Exception e) {
            log.error("error reload used services", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reloadServices() {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try (ServiceDao serviceDao = new ServiceDao(con);){
            HashMap<Integer, List<Service>> serviceMap = new HashMap<Integer, List<Service>>();
            HashMap<Integer, String> moduleSids = new HashMap<Integer, String>();
            List<Service> serviceList = serviceDao.list();
            this.getServiceData(serviceList, serviceMap, moduleSids);
            this.serviceList = serviceList;
            this.moduleServicesMap = serviceMap;
            this.moduleServicesStringMap = moduleSids;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void getServiceData(List<Service> serviceList, Map<Integer, List<Service>> serviceMap, Map<Integer, String> moduleSids) {
        for (Service service : serviceList) {
            List<Service> moduleServices = serviceMap.get(service.getModuleId());
            if (moduleServices == null) {
                moduleServices = new ArrayList<Service>();
                serviceMap.put(service.getModuleId(), moduleServices);
            }
            moduleServices.add(service);
        }
        for (Map.Entry entry : serviceMap.entrySet()) {
            String ids = Utils.toString((Iterable)Utils.getIdSet((Collection)((Collection)entry.getValue())), (String)",");
            if (Utils.isBlankString((String)ids)) {
                ids = "-1";
            }
            moduleSids.put((Integer)entry.getKey(), ids);
        }
    }

    private synchronized void setInstalledModules(Collection<BGModule> modules) {
        for (BGModule module : modules) {
            module.setInstalledModule(this.installedModulesMap.get(module.getName()));
        }
    }

    public synchronized List<BGModule> getModulesList() {
        return this.getModulesList(null);
    }

    public synchronized List<BGModule> getModulesList(String name) {
        if (name == null) {
            return this.moduleListTitleSorted.stream().map(BGModule::copy).toList();
        }
        ArrayList<BGModule> result = new ArrayList<BGModule>();
        for (BGModule module : this.moduleListTitleSorted) {
            if (!module.getName().equals(name)) continue;
            result.add(module.copy());
        }
        return result;
    }

    public synchronized List<BGModule> getModulesListWithIds(Set<Integer> ids) {
        ArrayList<BGModule> result = new ArrayList<BGModule>();
        for (BGModule module : this.getModulesList()) {
            if (!ids.contains(module.getId())) continue;
            result.add(module.copy());
        }
        return result;
    }

    public synchronized List<BGModule> getModulesListProcessSorted() {
        return this.moduleListProcessOrderSorted.stream().map(BGModule::copy).toList();
    }

    public synchronized List<BGModule> getModulesListProcessSorted(Set<Integer> ids) {
        ArrayList<BGModule> result = new ArrayList<BGModule>();
        for (BGModule module : this.getModulesListProcessSorted()) {
            if (!ids.contains(module.getId())) continue;
            result.add(module.copy());
        }
        return result;
    }

    public synchronized BGModule getModule(int id) {
        BGModule bgModule = this.moduleMap.get(id);
        return bgModule != null ? bgModule.copy() : null;
    }

    public Optional<BGModule> optModule(int id) {
        return Optional.ofNullable(this.getModule(id));
    }

    public synchronized Map<Integer, BGModule> getModuleMap() {
        HashMap<Integer, BGModule> map = new HashMap<Integer, BGModule>();
        this.moduleMap.forEach((a, b) -> map.put((Integer)a, b.copy()));
        return map;
    }

    public synchronized List<Service> getModuleUsedServicesList(int moduleId) {
        ArrayList<Service> services = new ArrayList<Service>();
        if (moduleId == 0) {
            services.addAll(this.usedServiceList.stream().map(Service::copy).toList());
        } else if (this.moduleUsedServicesMap.containsKey(moduleId)) {
            services.addAll(this.moduleUsedServicesMap.get(moduleId).stream().map(Service::copy).toList());
        }
        return services;
    }

    public synchronized List<Service> getModuleServicesList(int moduleId) {
        ArrayList<Service> services = new ArrayList<Service>();
        if (moduleId == 0) {
            services.addAll(this.serviceList.stream().map(Service::copy).toList());
        } else if (this.moduleServicesMap.containsKey(moduleId)) {
            services.addAll(this.moduleServicesMap.get(moduleId).stream().map(Service::copy).toList());
        }
        return services;
    }

    public int getModuleIdByServiceId(int serviceId) {
        return this.serviceList.stream().filter(a -> a.getId() == serviceId).findFirst().map(a -> a.getModuleId()).orElse(-1);
    }

    public synchronized String getModuleUsedServicesString(int moduleId) {
        if (this.moduleUsedServicesStringMap.containsKey(moduleId)) {
            return this.moduleUsedServicesStringMap.get(moduleId);
        }
        return "-1";
    }

    public synchronized String getModuleServicesString(int moduleId) {
        if (this.moduleServicesStringMap.containsKey(moduleId)) {
            return this.moduleServicesStringMap.get(moduleId);
        }
        return "-1";
    }

    public synchronized BGInstalledModule getInstalledModule(String name) {
        return this.installedModulesMap.get(name);
    }

    public synchronized List<BGInstalledModule> getInstalledModulesList() {
        return this.installedModules;
    }

    public synchronized String getPluginName(int id) {
        return this.installedModules.stream().filter(n -> n.getType() == ComponentType.PLUGIN).filter(a -> a.getId() == id).findFirst().map(a -> a.getName()).orElse(null);
    }

    public synchronized int getPluginId(String name) {
        return this.installedModules.stream().filter(n -> n.getType() == ComponentType.PLUGIN).filter(a -> a.getName().equals(name)).findFirst().map(a -> a.getId()).orElse(0);
    }

    public synchronized ApplicationModule getApplicationModule(String name) {
        return this.applicationModulesMap.get(name);
    }

    public synchronized ModuleAuth getAuthModule(String name) {
        return this.authModulesMap.get(name);
    }

    public <T extends DefaultClassExtension> List<T> extensionListForPoint(T clazzType, String extensionName) {
        ArrayList<DefaultClassExtension> result = new ArrayList<DefaultClassExtension>();
        List<BGModule> moduleList = ModuleCache.getInstance().getModulesList();
        for (BGModule instance : moduleList) {
            BGInstalledModule module = instance.getInstalledModule();
            Map<String, Element> extensionMap = module.getServerExtensionMap();
            if (extensionMap == null || !extensionMap.containsKey(extensionName)) continue;
            for (Element elem : XMLUtils.selectElements((Node)extensionMap.get(extensionName), (String)"class")) {
                String className = elem.getAttribute("class");
                try {
                    Class<?> clazz = Class.forName(className);
                    DefaultClassExtension extension = (DefaultClassExtension)clazz.getConstructor(Integer.TYPE).newInstance(instance.getId());
                    result.add(extension);
                }
                catch (Exception e) {
                    log.error("\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 [" + className + "] \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f " + module.getName() + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d\u043e");
                }
            }
        }
        return result;
    }
}

