/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.GroupRight;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RightType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class GroupRightDao
extends AbstractIdDao<GroupRight>
implements Directory<GroupRight> {
    public GroupRightDao(Connection con) {
        super(con, 0, "user_group_right");
    }

    @Override
    public GroupRight get(String title) throws BGException {
        GroupRight groupRight = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE title=" + title);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                groupRight = this.getFromRS(rs);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return groupRight;
    }

    @Override
    public List<GroupRight> list() throws BGException {
        ArrayList<GroupRight> list = new ArrayList<GroupRight>();
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM " + this.tableName + " ORDER BY title");){
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    protected GroupRight getFromRS(ResultSet rs) throws SQLException, BGException {
        GroupRight groupRight = new GroupRight();
        groupRight.setId(rs.getInt("id"));
        groupRight.setParentId(rs.getInt("parent_id"));
        groupRight.setModuleId(rs.getInt("module_id"));
        groupRight.setTitle(rs.getString("title"));
        groupRight.setType(RightType.getRightTypeByCode(rs.getByte("type")));
        return groupRight;
    }

    protected void updateImpl(GroupRight groupRight) throws BGException, SQLException {
        int index;
        String sql;
        boolean insert;
        boolean bl = insert = groupRight.getId() == 0;
        if (insert) {
            sql = "SELECT id FROM " + this.tableName + " WHERE parent_id=? AND module_id=? AND title=? AND type=?";
            try (PreparedStatement psSelect = this.con.prepareStatement(sql);){
                index = 1;
                psSelect.setInt(index++, groupRight.getParentId());
                psSelect.setInt(index++, groupRight.getModuleId());
                psSelect.setString(index++, groupRight.getTitle());
                psSelect.setByte(index, groupRight.getType().getCode());
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    groupRight.setId(rs.getInt(1));
                }
                rs.close();
            }
            if (groupRight.getId() > 0) {
                return;
            }
        }
        sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET parent_id=?, module_id=?, title=?, type=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(sql, 1);){
            index = 1;
            ps.setInt(index++, groupRight.getParentId());
            ps.setInt(index++, groupRight.getModuleId());
            ps.setString(index++, groupRight.getTitle());
            ps.setByte(index, groupRight.getType().getCode());
            if (insert) {
                ps.setInt(index++, groupRight.getId());
            }
            ps.executeUpdate();
            if (insert) {
                groupRight.setId(ServerUtils.lastInsertId(this.con));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

