/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.script.bean.Function;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class FunctionManager {
    protected String tableName = "";
    private Connection con;
    private static ConcurrentHashMap<String, List<Function>> functionCache = new ConcurrentHashMap();

    public FunctionManager(Connection con) {
        this.con = con;
        this.tableName = "script_function";
    }

    public List<Function> getScriptFunctions(int scriptId) {
        ArrayList<Function> result = new ArrayList<Function>();
        try {
            String query = "SELECT * FROM script_function WHERE script_id=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, scriptId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Function f = new Function();
                this.loadFunctionFromRS(rs, f);
                result.add(f);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Function getFunctionById(int id) {
        Function result = null;
        try {
            String query = "SELECT * FROM script_function WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Function();
                this.loadFunctionFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public Function getFunctionByID(int id) {
        return this.getFunctionById(id);
    }

    public void updateFunction(String id, Function f) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (id.equals("new")) {
                query = "INSERT INTO script_function (script_id, title, code, user_id)  VALUES (?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE script_function SET script_id=?, title=?, code=?, user_id=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, Utils.parseInt((String)id, (int)0));
            }
            ps.setInt(1, f.getScriptId());
            ps.setString(2, f.getTitle());
            ps.setString(3, f.getScript());
            ps.setInt(4, f.getUserId());
            ps.executeUpdate();
            if (id.equals("new")) {
                f.setId(ServerUtils.lastInsertId(ps));
            } else {
                f.setId(Utils.parseInt((String)id, (int)0));
            }
            f.setTimeRevision(this.getFunctionById(f.getId()).getTimeRevision());
            ps.close();
            this.updateEventTypes(f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteFunction(int id) {
        try {
            String query = "DELETE FROM script_function WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteScriptFunctions(int scriptID) {
        try {
            String query = "DELETE FROM script_function WHERE script_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, scriptID);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void resetFunctionCache() {
        functionCache.clear();
    }

    public List<Function> getEventProcessFunctions(int scriptId, int mid, int pluginId, int eventId) {
        String key;
        ArrayList<Function> result;
        Object midString = String.valueOf(mid);
        if (mid == 0 && pluginId > 0) {
            midString = "p" + pluginId;
        }
        if ((result = functionCache.get(key = scriptId + "_" + (String)midString + "_" + eventId)) == null) {
            ArrayList<Function> newResult = new ArrayList<Function>();
            try {
                String query = "SELECT script_function.* FROM script_function, script_function_event_type WHERE script_function.id=script_function_event_type.fid AND script_function.script_id=? AND script_function_event_type.mid=? AND script_function_event_type.event_id=? ORDER BY script_function.id";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, scriptId);
                ps.setString(2, (String)midString);
                ps.setInt(3, eventId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Function f = new Function();
                    this.loadFunctionFromRS(rs, f);
                    newResult.add(f);
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            result = functionCache.putIfAbsent(key, newResult);
            if (result == null) {
                result = newResult;
            }
        }
        return result;
    }

    public List<Function> getEventProcessFunctions() {
        ArrayList<Function> result = new ArrayList<Function>();
        try {
            String query = "SELECT script_function.* FROM script_function, script_function_event_type WHERE script_function.id=script_function_event_type.fid AND script_function_event_type.event_id NOT REGEXP '^[0-9]+$' AND CAST(script_function_event_type.event_id AS SIGNED INTEGER)=0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Function f = new Function();
                this.loadFunctionFromRS(rs, f);
                result.add(f);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void loadEventTypes(Function f) {
        try {
            ArrayList<String> eventTypes = new ArrayList<String>();
            PreparedStatement ps = this.con.prepareStatement("SELECT mid, event_id FROM script_function_event_type WHERE fid=?");
            ps.setInt(1, f.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                eventTypes.add(rs.getString(1) + "_" + rs.getString(2));
            }
            rs.close();
            ps.close();
            f.setEventTypeIdList(eventTypes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateEventTypes(Function f) {
        try {
            String query = "DELETE FROM script_function_event_type WHERE fid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, f.getId());
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO script_function_event_type (fid, mid, event_id) VALUES (?,?,?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, f.getId());
            for (String eventTypeId : f.getEventTypeIdList()) {
                String[] mid_event = eventTypeId.split("_");
                if (mid_event.length != 2) continue;
                ps.setString(2, mid_event[0]);
                ps.setString(3, mid_event[1]);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadFunctionFromRS(ResultSet rs, Function f) throws SQLException {
        f.setId(rs.getInt("id"));
        f.setScript(rs.getString("code"));
        f.setTitle(rs.getString("title"));
        f.setScriptId(rs.getInt("script_id"));
        f.setUserId(rs.getInt("user_id"));
        f.setTimeRevision(rs.getTimestamp("change_time"));
        this.loadEventTypes(f);
    }

    public Revision getRevisionProperties(int id) {
        try {
            String query = "SELECT id, user_id, change_time FROM script_function WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Revision result = new Revision();
                result.setId(rs.getInt("id"));
                result.setUserId(rs.getInt("user_id"));
                result.setUserName(UserMap.getUser(result.getUserId()).getName());
                result.setTimeRevision(rs.getTimestamp("change_time"));
                rs.close();
                ps.close();
                return result;
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void logFunctionProcess(DefaultServerSetup setup, ConnectionSet connectionSet, Calendar time, int contractId, String functionName, String out, String error, String ex, String warnings, long processTime, Logger logger) {
        StringBuffer report = new StringBuffer(out.length() + error.length() + 700);
        report.append("GENERATE_TIME: ");
        report.append(TimeUtils.format((Calendar)time, (String)"dd.MM.yy HH:mm:ss"));
        report.append("\nEXECUTION_STOP_TIME: ");
        report.append(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yy HH:mm:ss"));
        report.append("\nPROCESS_TIME: ");
        report.append(processTime);
        report.append("\n\nOUT:\n");
        report.append(out);
        if (Utils.notBlankString((String)error)) {
            report.append("\n\nERROR:\n");
            report.append(error);
        }
        if (Utils.notBlankString((String)ex)) {
            report.append("\n\nEXCEPTIONS:\n");
            report.append(ex);
        }
        if (Utils.notBlankString((String)warnings)) {
            report.append("\n\nWARNINGS:\n");
            report.append(warnings);
        }
        String tableName = ServerUtils.getMonthTableName("log_function_process", time.getTime());
        Connection trashCon = connectionSet.getTrashConnection(tableName, 1);
        try {
            String query;
            if (!ServerUtils.tableExists(trashCon, tableName)) {
                query = "CREATE TABLE IF NOT EXISTS " + tableName + "( id INT AUTO_INCREMENT NOT NULL, cid INT NOT NULL,  time DATETIME NOT NULL, title VARCHAR(250) NOT NULL,  data TEXT NOT NULL, PRIMARY KEY id(id), KEY cid (cid) )";
                ServerUtils.checkAndCreatePeriodicTableName(trashCon, tableName, query);
            }
            query = "INSERT INTO " + tableName + " (cid, time, title, data) VALUES (?, ?, ?, ?)";
            PreparedStatement ps = trashCon.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)time));
            ps.setString(3, functionName);
            ps.setString(4, report.toString());
            ps.executeUpdate();
            ps.close();
            if (Utils.notBlankString((String)ex) || Utils.notBlankString((String)warnings)) {
                if (contractId > 0) {
                    ContractManager contractManager = new ContractManager(connectionSet.getConnection());
                    Contract contract = contractManager.getContractById(contractId);
                    contractManager.close();
                    if (contract != null) {
                        report.insert(0, "Contract " + contract.getTitle() + "\n");
                    } else {
                        report.insert(0, "Contract id " + contractId + "\n");
                    }
                }
                String key = "bgbs.contract.script.error";
                AlarmSender.sendAlarm("bgbs.contract.script.error", 0L, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b BGBS \u0441\u043a\u0440\u0438\u043f\u0442\u0430", report.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

