/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load;

import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.load.DBProcessIn;
import bitel.billing.server.load.ProcessIn;
import bitel.billing.server.load.bean.Source;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public abstract class DefaultDataProcess {
    protected SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
    protected SimpleDateFormat YYYYMMDD = new SimpleDateFormat("yyyyMMdd");
    protected SimpleDateFormat DDMMYYYY_HHMMSS = new SimpleDateFormat("dd.MM.yyyy HH:MM:ss");
    protected SimpleDateFormat hourFormat = new SimpleDateFormat("dd-MM-yyyy HH:00:00");
    protected static Logger logger = LogManager.getLogger((String)"dataloader");
    protected Setup setup;
    protected ContractUtils _cu;
    protected Connection con;

    public abstract void proccess(ProcessIn var1, Connection var2);

    public abstract DBProcessIn getDBProcessIn(Setup var1, Source var2, Calendar var3, Connection var4);

    protected void clearErrorLog(Connection con, Date dt, int hh, int mid, int sourceId) throws SQLException {
        String tableName = "data_log_error_" + this.format.format(dt);
        if (ServerUtils.tableExists(con, tableName)) {
            String query = "DELETE FROM " + tableName + " WHERE dt=? AND hh=? AND mid=? ";
            if (ServerUtils.columnExist(con, tableName, "source_id")) {
                query = query + " AND source_id=" + sourceId;
            }
            PreparedStatement psDeleteError = con.prepareStatement(query);
            psDeleteError.setDate(1, dt);
            psDeleteError.setInt(2, hh);
            psDeleteError.setInt(3, mid);
            psDeleteError.executeUpdate();
            psDeleteError.close();
        }
    }

    protected PreparedStatement getInsertErrorLog(Connection con, Date dt, int hh, int mid, int sourceId) throws SQLException {
        Statement st;
        String tableName = "data_log_error_" + this.format.format(dt);
        String query = null;
        if (!ServerUtils.tableExists(con, tableName)) {
            query = "CREATE TABLE IF NOT EXISTS " + tableName + "( id int(11) NOT NULL auto_increment, dt date NOT NULL default '0000-00-00', hh tinyint(4) NOT NULL default 0, mid int(11) NOT NULL default 0, source_id int(11) NOT NULL default 0, msg_title varchar(100) NOT NULL default '', msg_data text NOT NULL, PRIMARY KEY (id), KEY mid_dt_hh_source (mid,dt,hh,source_id) )";
            st = con.createStatement();
            st.executeUpdate(query);
            st.close();
        }
        if (!ServerUtils.columnExist(con, tableName, "source_id")) {
            st = con.createStatement();
            st.executeUpdate("ALTER TABLE " + tableName + " ADD source_id int(11) NOT NULL default 0");
            st.executeUpdate("DELETE FROM " + tableName + " WHERE source_id=0");
            st.close();
        }
        query = "INSERT INTO " + tableName + " (dt, hh, mid, msg_title, msg_data, source_id) VALUES ( ?, ?, ?, ?, ?, ? )";
        PreparedStatement psInsertError = con.prepareStatement(query);
        psInsertError.setDate(1, dt);
        psInsertError.setInt(2, hh);
        psInsertError.setInt(3, mid);
        psInsertError.setInt(6, sourceId);
        return psInsertError;
    }

    protected void markProcessed(Timestamp time, int source, Connection con) throws SQLException {
        String tableName = "source_data_" + this.format.format(time);
        if (ServerUtils.tableExists(con, tableName)) {
            String query = "UPDATE " + tableName + " SET process=process | 1 WHERE dt=? AND source_id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setTimestamp(1, time);
            ps.setInt(2, source);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO " + tableName + " ( source_id, dt, process ) VALUES ( ?, ?, 1 )";
                ps = con.prepareStatement(query);
                ps.setInt(1, source);
                ps.setTimestamp(2, time);
                ps.executeUpdate();
            }
            ps.close();
        }
    }
}

