<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<div id="changeTariffResult"></div>

<ul class="nav nav-tabs mx-5">
  <li class="nav-item">
    <a class="nav-link active" aria-current="page" href="#">Тариф</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" href="#" onclick="showBlock( 'tariffRoot', 'list', tariffPlanQuery );">История</a>
  </li>
</ul>

<div class="tile tileTabs">
<c:choose>
	<c:when test="${mode eq 'selectTariff'}">
		<bg:blockTitle title="Изменение тарифа"/>
		<div class="paramColor" style="margin-top: 10px;">Текущий тариф:</div>
		<div class="titleFont3 mx-3" style="">${tariffMap[fromTariff.tariffPlanId].titleWeb}</div>
		<c:if test="${not empty tariffMap[fromTariff.tariffPlanId].description}"><div class="paramColor paramFont mx-3" style="margin: 5px;">${tariffMap[fromTariff.tariffPlanId].description}</div></c:if>
		<div class="paramColor" style="margin-top: 20px;">Новый тариф:</div>
		<c:forEach var="item" items="${toTariffList}">
		<div class="button1 newTariffButton" style="margin: 10px auto; width: 90%; cursor: pointer; border: 1px solid #888;" 
			onclick="showBlock( 'tariffRoot', 'selectDate', { ...tariffPlanQuery, fromTariffId: ${fromTariff.id}, toTariffId: ${item['id']} } ); return false;">
			<div class="titleFont3">${item.titleWeb}</div>
			<c:if test="${not empty item.description}"><div class="paramColor paramFont" style="margin: 5px;">${item.description}</div></c:if>
		</div>
		</c:forEach>
		<div class="formButtons"><button class="btn btn-outline-primary" onclick="showBlock( 'tariffRoot', 'tariff', tariffPlanQuery ); return false;">Отменить изменение тарифа</button></div>			
	</c:when>
	<c:when test="${mode eq 'selectDate'}">
		<bg:blockTitle title="Изменение тарифа"/>
		<div class="paramColor" style="margin-top: 10px;">Текущий тариф:</div>
		<div class="titleFont3 mx-3" style="">${tariffMap[fromTariff.tariffPlanId].titleWeb}</div>
		<div class="paramColor" style="margin-top: 10px;">Новый тариф:</div>
		<div class="titleFont3 mx-3" style="">${toTariff.titleWeb}</div>
		<div class="paramColor" style="margin-top: 10px;">Изменить тариф с:</div>
		<div class="flexRow mx-3" style="justify-content: start; flex-wrap: wrap;">
		<c:forEach var="item" items="${changeTariffDate}">
			<fmt:formatDate var="toTariffDate" value="${item}" type="DATE" dateStyle="SHORT" pattern="dd.MM.yyyy"/>
			<div class="btn btn-primary" style="margin: 5px; cursor: pointer; padding: 5px;"
			onclick="showBlock( 'changeTariffResult', 'changeTariff', { ...tariffPlanQuery, fromTariffId: ${fromTariff.id}, toTariffId: ${toTariff.id}, toTariffDate: '${toTariffDate}' } ); return false;"><fmt:formatDate value="${item}" type="DATE" dateStyle="SHORT"/></div>
		</c:forEach>
		</div>
		<div class="formButtons"><button class="btn btn-outline-primary" onclick="showBlock( 'tariffRoot', 'tariff', tariffPlanQuery ); return false;">Отменить изменение тарифа</button></div>			
	</c:when>
	<c:otherwise>
		<bg:blockTitle title="Текущие тарифы"/>
		<c:forEach var="item" varStatus="status" items="${tariffList}">
		<div style="margin: 10px;">
			<div class="flexRow">
				<div class="paramColor paramFont"><span><fmt:formatDate dateStyle="SHORT" value="${item['date1']}"/> - 
				<c:choose>
					<c:when test="${not empty item['date2']}"><fmt:formatDate dateStyle="SHORT" value="${item['date2']}"/></c:when>
					<c:otherwise>...</c:otherwise>
				</c:choose></span></div>
				<div class="paramColor paramFont"><c:if test="${item['type'] == '1'}">персональный тариф</c:if></div>
			</div>
			<div class="titleFont3 mx-3">${item['title']}</div>
			<c:if test="${not empty item['description']}"><div class="paramColor paramFont" style="margin: 5px;">${item['description']}</div></c:if>
			<c:set var="newTariff" value="${cancelMap[item['id']]}"/>
			<c:if test="${not empty newTariff}">
				<div style="; color: #888; margin-top: 10px;">Переход с <fmt:formatDate dateStyle="SHORT" value="${newTariff['date1']}"/> на тариф:</div>
				<div class="titleFont3 mx-3" style="margin: 5px 0px;">${newTariff['title']}</div>
				<c:if test="${newTariff['canCancel'] > 0}"><div class="formButtons"><button class="btn btn-primary" 
					onclick="showBlock( 'changeTariffResult', 'cancelChangeTariff', { ...tariffPlanQuery, contractTariffId: ${newTariff['id']} } ); return false;">Отменить смену тарифа</button></div>
				</c:if>
			</c:if>
			
			<c:if test="${not empty item['toTariffList']}"><div class="formButtons"><button class="btn btn-primary" 
				onclick="showBlock( 'tariffRoot', 'selectTariff', { ...tariffPlanQuery, fromTariffId: ${item['id']} } ); return false;">Сменить тариф</button></div></c:if>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
		</c:forEach>
	</c:otherwise>
</c:choose>
</div>

<%--
<div class="report">
	<table>
		 <tbody>
		 	<c:forEach var="item" items="${tariffList}">
			<tr>
				<td>
					<form method='get' action='' onsubmit="return confirm('Вы уверены, что хотите сменить тариф?')">
						<input type="hidden" name="action" value="ChangeTariff"/>
						<input type="hidden" name="command" value="change"/>
						<input type="hidden" name="tariff_group" value="${item['group']}"/>
						<table cellspacing="0" border="0">
							<td nowrap="1">	
								Перейти на тариф:
								<select name="to_tariff" >
									<c:forEach var="tariff" items="${item['tariff_list']}">
										<option value="${tariff.id}"> ${tariff.title}</option>
									</c:forEach>			
								</select>
								с даты:
								<select name="from_date" >
									<c:forEach var="date" items="${item['date_list']}">
										<option value="${date.value }" >${date.value }</option>
									</c:forEach>
								</select>
							</td>
						</table>
					</form>	
				</td>
			</tr>
		  </c:forEach>
		</tbody>	
	</table>
</div>
--%>
