/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.plugins.im.common.IMMessage;
import ru.bitel.bgbilling.plugins.im.common.RosterEntryItem;
import ru.bitel.bgbilling.plugins.im.common.RosterGroupItem;
import ru.bitel.bgbilling.plugins.im.common.RosterRootItem;

public class IMUtils {
    public static String getPureJID(String jid) {
        if (jid == null) {
            return null;
        }
        String result = jid.trim();
        int i = result.indexOf("/");
        if (i != -1) {
            result = result.substring(0, i);
        }
        return result;
    }

    public static String getJIDResource(String jid) {
        int i;
        String result = null;
        if (jid != null && (i = (jid = jid.trim()).indexOf("/")) != -1) {
            result = jid.substring(i + 1);
        }
        return result;
    }

    public static String getLoginFromJID(String jid) {
        int i;
        String result = null;
        if (jid != null && (i = (jid = jid.trim()).indexOf("@")) != -1) {
            result = jid.substring(0, i);
        }
        return result;
    }

    public void addMessageSort(List<IMMessage> list, IMMessage message) {
        int sindex1 = Collections.binarySearch(list, message, new MessageComparator());
        if (sindex1 >= 0) {
            list.add(sindex1, message);
        } else {
            list.add(-sindex1 - 1, message);
        }
    }

    public static List<IMMessage> cloneListAndClear(List<IMMessage> list) {
        ArrayList<IMMessage> ml = new ArrayList<IMMessage>();
        ml.addAll(list);
        list.clear();
        return ml;
    }

    public static RosterRootItem jsonToRoster(String jsonString) throws Exception {
        JSONObject resultJsonObject = new JSONObject(jsonString);
        RosterRootItem rri = new RosterRootItem();
        rri.user = resultJsonObject.has("user") ? resultJsonObject.getString("user") : null;
        JSONArray groups = resultJsonObject.getJSONArray("group");
        for (int ig = 0; ig < groups.length(); ++ig) {
            JSONObject group = groups.getJSONObject(ig);
            RosterGroupItem rgi = new RosterGroupItem();
            rri.addGroup(rgi);
            rgi.name = group.has("name") ? group.getString("name") : null;
            JSONArray entryes = group.getJSONArray("entry");
            for (int ie = 0; ie < entryes.length(); ++ie) {
                JSONObject entry = entryes.getJSONObject(ie);
                RosterEntryItem rei = new RosterEntryItem();
                rgi.addEntry(rei);
                rei.from = entry.has("from") ? entry.getString("from") : null;
                rei.name = entry.has("name") ? entry.getString("name") : null;
            }
        }
        return rri;
    }

    public static class MessageComparator
    implements Comparator<IMMessage> {
        @Override
        public int compare(IMMessage o1, IMMessage o2) {
            return Long.signum(o1.getTime() - o2.getTime());
        }
    }
}

