/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.plugins.edo.client.ParamNestEditor;
import ru.bitel.bgbilling.plugins.edo.common.bean.Document;
import ru.bitel.bgbilling.plugins.edo.common.service.DocumentService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.function.Async;

public class ServiceConfigDocument
extends BGUPanel {
    private BGUList<Document> documentList = new BGUList();
    private DocumentEditor documentEditor = new DocumentEditor();
    private JPanel rightPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();

    public ServiceConfigDocument() {
        JPanel emptyPanel = new JPanel(new GridBagLayout());
        emptyPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442"), new GridBagConstraints());
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add((Component)((Object)this.documentEditor), "editor");
        this.rightPanel.add((Component)emptyPanel, "empty");
        this.cardLayout.show(this.rightPanel, "empty");
        ClientUtils.addOpenAction(this.documentList, event -> this.performAction("edit"));
        ClientUtils.addShowCodeListener(this.documentList);
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setDividerSize(4);
        mainSplit.setDividerLocation(200);
        mainSplit.setLeftComponent(new JScrollPane((Component)this.documentList));
        mainSplit.setRightComponent(this.rightPanel);
        this.setLayout(new BorderLayout());
        this.add(mainSplit, "Center");
    }

    protected void jbInit() {
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.documentList.setData(((DocumentService)((ClientContext)this.getContext()).getPort(DocumentService.class)).getDocumentList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.startEdit(0));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Document li = (Document)this.documentList.getSelectedValue();
            if (li != null) {
                this.startEdit(li.getId());
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Document li = (Document)this.documentList.getSelectedValue();
            if (li != null && ClientUtils.confirmDelete((Object)"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442")) {
                ((DocumentService)((ClientContext)this.getContext()).getPort(DocumentService.class)).deleteDocument(li.getId());
                this.hideEditor();
            }
        });
    }

    private void startEdit(int id) {
        this.documentEditor.setId(id);
        this.cardLayout.show(this.rightPanel, "editor");
        this.documentEditor.performAction("refresh");
    }

    public void hideEditor() {
        this.cardLayout.show(this.rightPanel, "empty");
        this.performAction("refresh");
    }

    class DocumentEditor
    extends BGUPanel {
        private BGTextField fTitle = new BGTextField();
        private DynamicClassChooser fClass = new DynamicClassChooser(true);
        private ParamNestEditor fConfig = new ParamNestEditor();
        private int id;

        public DocumentEditor() {
            this.setLayout(new GridBagLayout());
            this.fClass.setIfaceName("ru.bitel.bgbilling.plugins.edo.server.bean.EdoBillFileGenerator");
            this.fClass.performAction("refresh");
            this.fClass.setNewClassPrefix("ru.bitel.bgbilling.modules.edo.dyn.");
            JButton okButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
            this.add(new JLabel("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.fTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add(new JLabel("\u041a\u043b\u0430\u0441\u0441:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.fClass, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add(new JScrollPane((Component)((Object)this.fConfig)), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add(okButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 5), 0, 0));
            okButton.addActionListener(e -> ServiceConfigDocument.this.performAction("ok"));
        }

        protected void jbInit() {
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
                if (this.id > 0) {
                    Document document = ((DocumentService)((ClientContext)this.getContext()).getPort(DocumentService.class)).getDocument(this.id);
                    this.fTitle.setText(document.getTitle());
                    this.fClass.setSelectedItem(document.getClazz());
                    this.fConfig.setText(document.getConfig());
                } else {
                    this.fTitle.setText("\u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                    this.fClass.clearSelection();
                    this.fConfig.setText(null);
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Utils.isEmptyString((String)DocumentEditor.this.fTitle.getText().trim())) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a!");
                        return;
                    }
                    Document document = new Document();
                    document.setId(DocumentEditor.this.id);
                    document.setTitle(DocumentEditor.this.fTitle.getText());
                    document.setClazz(DocumentEditor.this.fClass.getSelectedClass());
                    document.setConfig(DocumentEditor.this.fConfig.getText());
                    ((DocumentService)((ClientContext)DocumentEditor.this.getContext()).getPort(DocumentService.class)).updateDocument(document);
                    ServiceConfigDocument.this.hideEditor();
                }
            };
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

