/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.action.web;

import bitel.billing.server.ActionConType;
import jakarta.annotation.PostConstruct;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@ActionConType(value=2)
@WebAction(title="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b")
public class ActionDocuments
extends AbstractAction {
    private DocumentsService service;

    public ActionDocuments() {
        super("documents");
    }

    @PostConstruct
    public void init() throws BGException {
        this.service = (DocumentsService)this.context.newService(DocumentsService.class, this.moduleId);
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432")
    public void list() throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(new Page(1, 0));
        searchResult.setList(this.service.getDocumentList(this.contractId, null, new Period()).stream().filter(a -> a.isShowInLK()).toList());
        this.setResultParam("searchResult", searchResult);
        this.setResultParam("journalList", this.service.documentJournalList());
        this.setResultParam("typeList", this.service.documentTypeList());
        this.requestDispatcher(this.moduleName, "list");
    }

    @WebOperation(title="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435")
    public void info() throws BGException {
        int documentId = this.req.getInt("id", -1);
        Document document = this.service.getDocument(documentId);
        if (document != null && document.getContractId() == this.contractId && document.isShowInLK()) {
            this.setResultParam("userMap", UserMap.getMap());
            this.setResultParam("statusList", this.service.documentStatusList());
            this.setResultParam("statusLog", this.service.getDocumentStatusLogList(documentId));
            this.setResultParam("documentFileList", this.service.getDocumentFileList(documentId));
        }
        this.requestDispatcher(this.moduleName, "info");
    }
}

