/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.base.server.wrapper.CaseInsensitiveParameterWrapper;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.YoomoneyRequest;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.util.DebugUtils;

@WebServlet(name="YoomoneyExecutor", urlPatterns={"/yaexecuter/*"})
public class ModuleExecuter
extends CommonExecutor {
    private static final int ERROR_CODE_OK = 0;
    private static final int ERROR_CODE_AUTH = 1;
    private static final int ERROR_CODE_REJECT = 100;
    private static final int ERROR_CODE_REQUEST = 200;
    private static final int ERROR_CODE_INTERNAL = 1000;
    private static final Logger logger = LogManager.getLogger();
    private static final String ACTION_CHECK = "Check";
    private static final String ACTION_SUCCESS = "PaymentSuccess";

    public void init() {
        this.setup = Setup.getSetup();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new IllegalAccessError("HTTP-GET-requests can not be!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest request0, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            block12: {
                block11: {
                    request = new CaseInsensitiveParameterWrapper(request0);
                    mid = Utils.parseInt((String)request.getParameter("mid"));
                    if (mid <= 0) {
                        ModuleExecuter.logger.error("GET-parameter mid required!");
                        ModuleExecuter.doReply((HttpServletRequest)request, response, 200, "GET-parameter mid required");
                        return;
                    }
                    try {
                        yoomoneyRequest = ModuleExecuter.parseParam((HttpServletRequest)request);
                    }
                    catch (BGException e) {
                        ModuleExecuter.doReply((HttpServletRequest)request, response, 200, "error parameters " + e.toString());
                        ModuleExecuter.logger.error("error do post, error parameters", (Throwable)e);
                        return;
                    }
                    ModuleExecuter.logger.debug("do action " + yoomoneyRequest.getAction() + " : " + DebugUtils.dumpObject((Object)yoomoneyRequest));
                    con = null;
                    moduleSetup = this.setup.getModuleSetup(Integer.valueOf(mid));
                    con = this.setup.getDBConnectionFromPool();
                    if (!ModuleExecuter.checkAuth(yoomoneyRequest, (Preferences)moduleSetup)) ** GOTO lbl51
                    shopId_p = moduleSetup.getLong("yoomoney.shopId", -1L);
                    if (yoomoneyRequest.getShopId() != shopId_p) {
                        throw new BGException("error shopId (config=" + shopId_p + ",request=" + yoomoneyRequest.getShopId() + ")");
                    }
                    manager = new TransactionManager(con, mid);
                    transaction = manager.getTransactionForInvoice(yoomoneyRequest.getInvoiceId());
                    manager.close();
                    if (transaction == null) break block11;
                    if ("Check".equals(yoomoneyRequest.getAction())) {
                        throw new BGException("transaction InvoiceId=" + yoomoneyRequest.getInvoiceId() + " exists, action=Check");
                    }
                    ModuleExecuter.doReply((HttpServletRequest)request, response, 0, "OK (Re-send)");
                    ServerUtils.closeConnection((Connection)con);
                    return;
                }
                contractDao = new ContractDao(con, 0);
                contract = contractDao.getByTitle(yoomoneyRequest.getCustomerNumber());
                contractDao.close();
                if (!"Check".equals(yoomoneyRequest.getAction())) break block12;
                if (contract != null) ** GOTO lbl48
                ModuleExecuter.logger.warn("reject transaction: not valid customerNumber=" + yoomoneyRequest.getCustomerNumber());
                ModuleExecuter.doReply((HttpServletRequest)request, response, 100, "not valid customerNumber=" + yoomoneyRequest.getCustomerNumber());
                ServerUtils.closeConnection((Connection)con);
                return;
            }
            try {
                transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contract.getId())).setSum(yoomoneyRequest.getOrderSumAmount())).setShopSumAmount(yoomoneyRequest.getShopSumAmount()).setPaymentPayerCode(yoomoneyRequest.getPaymentPayerCode()).setTransactionDate(yoomoneyRequest.getPaymentDateTime())).build();
                manager.update(transaction);
                manager.carryOutPayment(transaction);
lbl48:
                // 2 sources

                manager.close();
                ModuleExecuter.doReply((HttpServletRequest)request, response, 0, "OK");
                break block13;
lbl51:
                // 1 sources

                ModuleExecuter.doReply((HttpServletRequest)request, response, 1, "auth failed");
            }
            catch (Exception e) {
                try {
                    ModuleExecuter.logger.error("error do post", (Throwable)e);
                    ModuleExecuter.doReply((HttpServletRequest)request, response, 1000, e.toString());
                }
                catch (Throwable var14_15) {
                    ServerUtils.closeConnection(con);
                    throw var14_15;
                }
                ServerUtils.closeConnection((Connection)con);
            }
        }
        ServerUtils.closeConnection((Connection)con);
    }

    private static void doReply(HttpServletRequest request, HttpServletResponse response, int code, String techMessage) throws IOException {
        String performedDatetime = ModuleExecuter.formatDateTime(new Date());
        String action = request.getParameter("action");
        String shopId = request.getParameter("shopId");
        String invoiceId = request.getParameter("invoiceId");
        Object techMessageAttribute = "";
        if (code != 0 && techMessage != null) {
            techMessageAttribute = "techMessage=\"" + techMessage + "\"";
        }
        PrintWriter out = response.getWriter();
        out.println("<?xml version=\"1.0\" encoding=\"windows-1251\"?>");
        out.println("<response performedDatetime=\"" + performedDatetime + "\">");
        out.println("\t<result code=\"" + code + "\" action=\"" + action + "\" shopId=\"" + shopId + "\" invoiceId=\"" + invoiceId + "\" " + (String)techMessageAttribute + " />");
        out.println("</response>");
        out.flush();
        out.close();
        logger.debug("do reply " + code + " (" + techMessage + ")");
    }

    private static String formatDateTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getTimeZone("Europe/Moscow"));
        Object datestr = df.format(date);
        datestr = ((String)datestr).substring(0, ((String)datestr).length() - 2) + ":" + ((String)datestr).substring(((String)datestr).length() - 2);
        return datestr;
    }

    private static Date parseDateTime(String date) throws BGException {
        if (date != null) {
            try {
                if (((String)date).endsWith(":00")) {
                    date = ((String)date).substring(0, ((String)date).length() - 3) + ((String)date).substring(((String)date).length() - 2);
                }
                date = ((String)date).replace("Z", "+0000");
                date = ((String)date).replaceAll("\\.\\d\\d\\d", "");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                return df.parse((String)date);
            }
            catch (ParseException e) {
                throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u0430\u0442\u044b: " + (String)date);
            }
        }
        return null;
    }

    private static long parseLong(String int64) throws BGException {
        if (int64 != null) {
            try {
                return Long.parseLong(int64);
            }
            catch (NumberFormatException e) {
                throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0446\u0435\u043b\u043e\u0433\u043e: " + int64);
            }
        }
        return -1L;
    }

    private static BigDecimal parseCurrencyAmount(String sum) throws BGException {
        if (sum != null) {
            try {
                return new BigDecimal(sum);
            }
            catch (NumberFormatException e) {
                throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0443\u043c\u043c\u044b: " + sum);
            }
        }
        return null;
    }

    private static YoomoneyRequest parseParam(HttpServletRequest request) throws BGException {
        YoomoneyRequest yoomoneyRequest = new YoomoneyRequest();
        yoomoneyRequest.setRequestDatetime(ModuleExecuter.parseDateTime(request.getParameter("requestDatetime")));
        if (yoomoneyRequest.getRequestDatetime() == null) {
            throw new BGException("request-parameter 'requestDatetime' require");
        }
        yoomoneyRequest.setAction(request.getParameter("action"));
        if (yoomoneyRequest.getAction() == null) {
            throw new BGException("request-parameter 'action' require");
        }
        if (!ACTION_CHECK.equals(yoomoneyRequest.getAction()) && !ACTION_SUCCESS.equals(yoomoneyRequest.getAction())) {
            throw new BGException("request-parameter 'action' not valid: " + yoomoneyRequest.getAction());
        }
        yoomoneyRequest.setPgpSignature(request.getParameter("pgpSignature"));
        yoomoneyRequest.setMd5(request.getParameter("md5"));
        yoomoneyRequest.setShopId(ModuleExecuter.parseLong(request.getParameter("shopId")));
        if (yoomoneyRequest.getShopId() <= 0L) {
            throw new BGException("parameter 'shopId' require");
        }
        yoomoneyRequest.setInvoiceId(ModuleExecuter.parseLong(request.getParameter("invoiceId")));
        if (yoomoneyRequest.getInvoiceId() <= 0L) {
            throw new BGException("parameter 'invoiceId' require");
        }
        yoomoneyRequest.setCustomerNumber(request.getParameter("customerNumber"));
        yoomoneyRequest.setOrderCreatedDatetime(ModuleExecuter.parseDateTime(request.getParameter("orderCreatedDatetime")));
        yoomoneyRequest.setOrderSumAmount(ModuleExecuter.parseCurrencyAmount(request.getParameter("orderSumAmount")));
        if (yoomoneyRequest.getOrderSumAmount() == null) {
            throw new BGException("request-parameter 'orderSumAmount' require");
        }
        yoomoneyRequest.setShopSumAmount(ModuleExecuter.parseCurrencyAmount(request.getParameter("shopSumAmount")));
        if (yoomoneyRequest.getShopSumAmount() == null) {
            throw new BGException("request-parameter 'shopSumAmount' require");
        }
        yoomoneyRequest.setPaymentPayerCode(request.getParameter("paymentPayerCode"));
        if (yoomoneyRequest.getPaymentPayerCode() == null) {
            throw new BGException("request-parameter 'paymentPayerCode' require");
        }
        yoomoneyRequest.setOrderIsPaid("1".equals(request.getParameter("orderIsPaid")));
        if (ACTION_SUCCESS.equals(yoomoneyRequest.getAction()) && !yoomoneyRequest.isOrderIsPaid()) {
            throw new BGException("parameter 'orderIsPaid' must be '1' with action 'PaymentSuccess'");
        }
        yoomoneyRequest.setPaymentDateTime(ModuleExecuter.parseDateTime(request.getParameter("paymentDateTime")));
        return yoomoneyRequest;
    }

    private static boolean checkAuth(YoomoneyRequest yoomoneyRequest, Preferences moduleSetup) throws BGException {
        String orderIsPaid = yoomoneyRequest.isOrderIsPaid() ? "1" : "0";
        String orderSumAmount = yoomoneyRequest.getOrderSumAmount().toString();
        String shopId = String.valueOf(yoomoneyRequest.getShopId());
        String invoiceId = String.valueOf(yoomoneyRequest.getInvoiceId());
        String customerNumber = yoomoneyRequest.getCustomerNumber();
        String authMethod = moduleSetup.get("yoomoney.authMethod", null);
        if (authMethod == null) {
            throw new BGException("config parameter 'authMethod' require");
        }
        if ("md5".equals(authMethod)) {
            String shopPassword = moduleSetup.get("yoomoney.shopPassword", null);
            if (shopPassword == null) {
                throw new BGException("config parameter 'shopPassword' require for md5-mode");
            }
            String md5 = yoomoneyRequest.getMd5();
            if (md5 == null) {
                throw new BGException("http-parameter 'md5' missing");
            }
            String digest = Utils.getDigest((String)(orderIsPaid + ";" + orderSumAmount + ";;;" + shopId + ";" + invoiceId + ";" + customerNumber + ";" + shopPassword), (String)"cp1251");
            return digest.equalsIgnoreCase(md5);
        }
        if ("pgp".equals(authMethod)) {
            String shopPgpKey = moduleSetup.get("yoomoney.shopPgpKey", null);
            if (shopPgpKey == null) {
                throw new BGException("config parameter 'shopPgpKey' require for pgp-mode");
            }
            String pgpSignature = yoomoneyRequest.getPgpSignature();
            if (pgpSignature == null) {
                throw new BGException("http-parameter 'pgpSignature' missing");
            }
            throw new BGException("auth method pgp not available now");
        }
        throw new BGException("config parameter 'authMethod'='" + authMethod + "' unknown");
    }
}

