/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.client;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.TransactionStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class TransactionTableModel
extends AbstractTransactionTableModel<Transaction> {
    public static final String COLUMN_CANCELLATION_DETAILS = "cancellationDetails";
    public static final String COLUMN_CONTRACT_COMMENT = "contractComment";
    public static final String COLUMN_ORDER_SUM_AMOUNT = "orderSumAmount";
    public static final String COLUMN_SHOP_SUM_AMOUNT = "shopSumAmount";
    public static final String COLUMN_PAYMENT_PAYER_CODE = "paymentPayerCode";
    public static final String COLUMN_PAYMENT_DATE_TIME = "paymentDateTime";
    public static final String COLUMN_PAYMENT_TYPE = "paymentType";
    public static final String COLUMN_TITLE_INVOICE_ID = "YoomoneyID";
    public static final String COLUMN_TITLE_CONTRACT_COMMENT = "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
    public static final String COLUMN_TITLE_PAYMENT_DATE_TIME = "\u0412\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f/\u043e\u043f\u043b\u0430\u0442\u044b";

    public TransactionTableModel(String name) {
        super(name, Transaction.class);
    }

    public Object getValue(Transaction value, int column) throws BGException {
        String identifier = this.getIdentifier(column);
        if (identifier.equals(COLUMN_ORDER_SUM_AMOUNT)) {
            return value != null ? value.getSum() : "";
        }
        if (identifier.equals(COLUMN_SHOP_SUM_AMOUNT)) {
            return value != null ? value.getShopSumAmount() : "";
        }
        if (COLUMN_CANCELLATION_DETAILS.equals(identifier)) {
            Object result = "";
            if (value.getStatus().equals(TransactionStatus.CANCELED.getCode())) {
                try {
                    JSONObject jsonObject = new JSONObject(value.getRawRequest());
                    Object party = jsonObject.optQuery("/object/cancellation_details/party");
                    Object reason = jsonObject.optQuery("/object/cancellation_details/reason");
                    if (party != null || reason != null) {
                        String sparty = party != null ? String.valueOf(party) : null;
                        String sreason = reason != null ? String.valueOf(reason) : null;
                        result = Transaction.getCancelComment((String)sparty, (String)sreason) + " (" + Utils.maskNull((String)sparty) + ":" + Utils.maskNull((String)sreason) + ")";
                    }
                }
                catch (Exception jsonObject) {
                    // empty catch block
                }
            }
            return result;
        }
        if (COLUMN_PAYMENT_DATE_TIME.equals(identifier)) {
            LocalDateTime date = null;
            if (value.getRawRequest() != null) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject = new JSONObject(value.getRawRequest());
                }
                catch (Exception party) {
                    // empty catch block
                }
                JSONObject object = jsonObject.optJSONObject("object");
                if (object != null) {
                    jsonObject = object;
                }
                Object capturedAt = jsonObject.optQuery("/captured_at");
                Object createdAt = jsonObject.optQuery("/created_at");
                String dateStr = null;
                if (capturedAt instanceof String) {
                    String d;
                    dateStr = d = (String)capturedAt;
                } else if (createdAt instanceof String) {
                    String d;
                    dateStr = d = (String)createdAt;
                }
                if (dateStr != null) {
                    if (dateStr.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d+Z$")) {
                        date = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX"));
                    } else if (dateStr.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z$")) {
                        date = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX"));
                    }
                }
            }
            return date != null ? TimeUtils.format(date, (String)"dd.MM.yyyy HH:mm:ss") : "";
        }
        return super.getValue((Object)value, column);
    }
}

