/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxClientPairData;
import ru.bitel.bgbilling.modules.vidimax.server.bean.VidimaxClientPairDataDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.vidimax.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        super.moduleAction(ctx, mid, event);
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            Connection con = ctx.getConnection();
            if (!cdEvent.isCheck()) {
                try (VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(con, mid);){
                    pairDataDao.deleteByContractId(cdEvent.getContractId());
                }
            }
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mid));
            boolean canDelete = moduleSetup.getBoolean("contract.canDeletePaired", false);
            if (!canDelete) {
                try (VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(con, mid);){
                    VidimaxClientPairData pairData = pairDataDao.getByContractid(event.getContractId());
                    if (pairData != null && pairData.isPair()) {
                        cdEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441\u0432\u044f\u0437\u0430\u043d \u0441 Vidimax.");
                        return;
                    }
                }
            }
        }
    }
}

