/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.server.event.worker;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.uniteller.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class UnitellerCheckEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;

    public UnitellerCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), UnitellerCheckEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.getLogger().info("Starting UnitellerCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "uniteller-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.transactionManager.close();
            this.transactionManager = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        UnitellerCheckEvent event = (UnitellerCheckEvent)((Object)task);
        this.transactionManager.doCheckRequest(event.getContractId());
        return null;
    }
}

