/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractOptionDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductDao;
import ru.bitel.common.model.Page;

public class MegafonCheckOrderStatus
extends BGLogger {
    private static final Logger log = LogManager.getLogger(MegafonCheckOrderStatus.class);
    private static MegafonCheckOrderStatus INSTANCE;
    private final int workPeriodInMinutes = 3;
    private long delay = 10000L;
    private boolean isWork = false;
    private Date lastCheckTime;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> scheduledTask;

    private MegafonCheckOrderStatus() {
    }

    public static MegafonCheckOrderStatus getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = new MegafonCheckOrderStatus();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return INSTANCE;
    }

    public synchronized void checkOrders() throws BGException {
        this.lastCheckTime = new Date();
        if (this.isWork) {
            return;
        }
        this.isWork = true;
        log.info("Megafon start checking change order status for products and options");
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        ServerContext context = (ServerContext)ServerContext.get();
        MegafonApiClient apiClient = new MegafonApiClient(context.getModuleId());
        MegafonContractService megafonContractService = (MegafonContractService)context.getService(MegafonContractService.class, context.getModuleId());
        MegafonContractProductDao contractProductDao = new MegafonContractProductDao(context.getConnection(), context.getModuleId());
        MegafonContractOptionDao contractOptionDao = new MegafonContractOptionDao(context.getConnection(), context.getModuleId());
        this.scheduledTask = this.executor.scheduleWithFixedDelay(() -> {
            try {
                if (!this.shouldContinueWorking()) {
                    this.stopChecking();
                    return;
                }
                this.contractProductProcess(apiClient, megafonContractService, contractProductDao);
                this.contractOptionProcess(apiClient, megafonContractService, contractOptionDao, contractProductDao);
                Thread.sleep(this.delay);
            }
            catch (Exception e) {
                this.logError(e);
            }
        }, 0L, this.delay, TimeUnit.MILLISECONDS);
    }

    private void contractProductProcess(MegafonApiClient apiClient, MegafonContractService megafonContractService, MegafonContractProductDao contractProductDao) throws Exception {
        for (MegafonContractProduct megafonContractProduct : contractProductDao.list(new Page(), "(status=? OR status=?) AND order_id>0", "", MegafonContractProductStatus.ACTIVATION_ORDERED, MegafonContractProductStatus.DEACTIVATION_ORDERED).getList()) {
            if (!this.checkDoneOrderStatus(apiClient, megafonContractProduct.getOrderId())) continue;
            this.getLogger().debug(String.format("\u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u0417\u0430\u043a\u0430\u0437 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d. contractId=%s, megafonContractProductId=%s, productId=%s, status=%s", megafonContractProduct.getContractId(), megafonContractProduct.getId(), megafonContractProduct.getProductId(), megafonContractProduct.getStatus().getComment()));
            if (megafonContractProduct.getStatus().equals((Object)MegafonContractProductStatus.ACTIVATION_ORDERED)) {
                megafonContractService.productActivate(megafonContractProduct);
                continue;
            }
            if (!megafonContractProduct.getStatus().equals((Object)MegafonContractProductStatus.DEACTIVATION_ORDERED)) continue;
            megafonContractService.productDeactivate(megafonContractProduct);
        }
    }

    private void contractOptionProcess(MegafonApiClient apiClient, MegafonContractService megafonContractService, MegafonContractOptionDao contractOptionDao, MegafonContractProductDao contractProductDao) throws Exception {
        for (MegafonContractOption option : contractOptionDao.list(new Page(), "status=? AND order_id>0", "", MegafonContractProductStatus.ACTIVATION_ORDERED).getList()) {
            if (!this.checkDoneOrderStatus(apiClient, option.getOrderId())) continue;
            megafonContractService.optionActivate((MegafonContractProduct)contractProductDao.get(option.getContractProductId()), option);
        }
    }

    private boolean checkDoneOrderStatus(MegafonApiClient apiClient, long orderId) {
        return OrderStatus.DONE.equals((Object)OrderStatus.getOrderStatusByCode(apiClient.getOrderInfo(orderId).optJSONObject("status").optInt("orderStatusId")));
    }

    private boolean shouldContinueWorking() {
        return this.lastCheckTime != null && System.currentTimeMillis() - this.lastCheckTime.getTime() <= 180000L;
    }

    public synchronized void stopChecking() {
        this.isWork = false;
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public static enum OrderStatus {
        CREATED(1, "\u0421\u043e\u0437\u0434\u0430\u043d"),
        IN_PROGRESS(2, "\u0412 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435"),
        DONE(3, "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d"),
        ANNUL(4, "\u0410\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d"),
        ERR(5, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f"),
        REOPEN(6, "\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d"),
        ROLLED_BACK(7, "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u043e\u0442\u043a\u0430\u0442"),
        ERR_ROLLED_BACK(8, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043a\u0430\u0442\u0430");

        private final int status;
        private final String description;

        private OrderStatus(int status, String description) {
            this.status = status;
            this.description = description;
        }

        public int getStatus() {
            return this.status;
        }

        public String getDescription() {
            return this.description;
        }

        public static OrderStatus getOrderStatusByCode(int code) {
            for (OrderStatus s : OrderStatus.values()) {
                if (s.status != code) continue;
                return s;
            }
            return null;
        }
    }
}

