<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<div id="licenseEditComponent"></div>
<div id="licenseResult"></div>

<div class="titleFont2 headerRow" style="margin-bottom: 10px;">Выбранные компоненты</div>
<c:choose>
	<c:when test="${not empty orders}">
	<c:forEach var="item" varStatus="status" items="${orders}">
		<div class="flexRow">
			<div>
				<div class="titleFont2">${componentMap[item.componentId].title}</div>
				<div class="flexRow" style="flex-wrap: wrap; margin-top: 5px;">
					<div class="paramColor paramFont" style="width: 10rem;">Тип: <span><c:choose><c:when test="${item.type.code == 0}">тестовая</c:when><c:when test="${item.type.code == 1}">постоянная</c:when><c:otherwise>н/о</c:otherwise></c:choose> </span></div>
					<div class="paramColor paramFont" style="width: 12rem;">Количество: <span><c:choose><c:when test="${item.count > 0}">${item.count}</c:when><c:otherwise>неограничено</c:otherwise> </c:choose></span></div>
					<c:if test="${item.type.code == 0}"><div class="paramColor paramFont" style="width: 10rem;">Период (дней): <span>${item.term}</span></div></c:if>
				</div>
			</div>
			<div class="flexRow" style="font-size: 0px;">
				<div onclick="showBlock( 'licenseEditComponent', 'licenseEditComponent', { ...licenseQuery, orderIndex: ${status.index} } ); return false;"><img src="${pageContext.request.contextPath}/img/edit.png" title="редактирование" class="iconButton"></div>
				<div onclick="showBlock( 'productItems', 'licenseOrderComponents', { ...licenseQuery, orderIndex: ${status.index} } ); return false;"><img src="${pageContext.request.contextPath}/img/delete.png" title="удаление" class="iconButton"></div>
			</div>
		</div>
		<c:if test="${not status.last}"><div class="line2" style="margin-top: 5px;"></div></c:if>
	</c:forEach>
	</c:when>
	<c:otherwise><bg:dataNotFound marginTop="1"/></c:otherwise>
</c:choose>

<div class="titleFont2 headerRow" style="margin: 10px 0px;">Доступные компоненты</div>
<div class="d-flex flex-row">
	<div class="">
		<div class="fs-6 text-nowrap">Фильтр по категории:</div>
		<div class="">
			<style type="text/css">button.licFilterButSel${categoryId} { font-weight: bold; }</style>
			<div><button onclick="return filterComponentCategory( -1 );" class="btn btn-outline-primary licFilterButSel-1 w-100" style="margin: 0.3rem;">ВСЕ</button></div>
			<c:forEach var="item" items="${componentCategory}"><div><button onclick="return filterComponentCategory( ${item.code} );" class="btn btn-outline-primary licFilterButSel${item.code} w-100" style="margin: 0.3rem;">${item.title}</button></div></c:forEach>	 
		</div>
	</div>
	<div class="flex-grow-1">
	<c:choose>
		<c:when test="${not empty productItems}">
		<div class="d-grid text-center" style="grid-template-columns: repeat( auto-fit, minmax( 15rem, 1fr ) ); grid-column-gap: 0; margin-top: 20px; margin-left: 2rem;">
		<c:forEach var="item" varStatus="status" items="${productItems}">
			<c:if test="${item.availableOnWeb}">
				<div class="card m-3">
					<div class="card-header">${item.title}</div>
					<div class="card-body text-end">
						<button class="btn btn-primary w-45" onclick="return addComponent( ${item.id}, 0 );">тестовые</button>
						<button class="btn btn-primary w-45" onclick="return addComponent( ${item.id}, 1 );">постоянные</button>
					</div>
				</div>
			</c:if>
		</c:forEach>
		</div>
		</c:when>
		<c:otherwise><div class="mx-5"><bg:dataNotFound/></div></c:otherwise>
	</c:choose>
	</div>
</div>

<div class="formButtons"><button class="btn btn-primary" onclick="showBlock( 'licenseResult', 'addOrder', licenseQuery ); return false;">Отправить заказ</button></div>
