/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action;

import bitel.billing.server.ActionBase;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderBillData;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ActionGetSelectedItemBills
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.mid);
        ArrayList<Integer> processedIds = new ArrayList<Integer>();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        BigDecimal totalPaySum = BigDecimal.ZERO;
        int copyId = this.getIntParameter("copyId", -1);
        int ordersCount = this.getIntParameter("ordersCount", -1);
        Copy copy = licenseManager.getCopy(copyId);
        String productVersion = copy.getProductVersion();
        for (int i = 0; i < ordersCount; ++i) {
            int productItemId;
            int selectedOrderId = this.getIntParameter("id_" + i, -1);
            Order order = licenseManager.getOrder(selectedOrderId);
            if (order == null || processedIds.contains(productItemId = order.getComponentId())) continue;
            processedIds.add(productItemId);
            ConfirmedOrder grouppedConfirmedItem = licenseManager.groupCopyItems(productItemId, copyId, new int[]{2, 3});
            ConfirmedOrder grouppedNewItem = licenseManager.groupCopyItems(productItemId, copyId, new int[]{0});
            if (grouppedConfirmedItem == null && grouppedNewItem == null) continue;
            Element row = this.createElement(data, "row");
            row.setAttribute("title", order.getComponentTitle());
            String productItemName = new String();
            Integer confirmedItemsCount = null;
            if (grouppedConfirmedItem != null) {
                confirmedItemsCount = grouppedConfirmedItem.getCount();
                productItemName = grouppedConfirmedItem.getComponentName();
            }
            Integer newItemsCount = null;
            if (grouppedNewItem != null) {
                newItemsCount = grouppedNewItem.getCount();
                productItemName = grouppedNewItem.getComponentName();
            }
            OrderBillData addCostItem = LicenseUtils.getCostDelta(productItemName, confirmedItemsCount, newItemsCount, productVersion, (Preferences)this.moduleSetup);
            row.setAttribute("exist_count", OrderUtils.getCount((Integer)addCostItem.getConfirmedCount()));
            row.setAttribute("exist_cost", Utils.formatCost((BigDecimal)addCostItem.getConfirmedCost()));
            row.setAttribute("new_count", OrderUtils.getCount((Integer)addCostItem.getCountDelta()));
            row.setAttribute("total_count", OrderUtils.getCount((Integer)addCostItem.getTotalCount()));
            row.setAttribute("total_cost", Utils.formatCost((BigDecimal)addCostItem.getTotalCost()));
            row.setAttribute("new_cost", Utils.formatCost((BigDecimal)addCostItem.getCostDelta()));
            row.setAttribute("pay_sum", Utils.formatCost((BigDecimal)addCostItem.getCostDelta()));
            totalPaySum = totalPaySum.add(addCostItem.getCostDelta());
        }
        Element totalSum = this.createElement(table, "totalSum");
        totalSum.setAttribute("value", Utils.formatCost((BigDecimal)totalPaySum));
    }
}

