/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.client.model.EntitySpecAttrTableModel;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class EntitySpecAttrPanel
extends BGUPanel {
    private EntityService entityService = null;
    private EntitySpecAttrTableModel model = new EntitySpecAttrTableModel(EntitySpecAttrTableModel.class.getName());

    public EntitySpecAttrPanel() {
        super(new GridBagLayout());
        this.setName("entitySpecAttrPanel");
    }

    private EntityService getEntityService() {
        if (this.entityService == null) {
            this.entityService = ((ClientContext)this.getContext()).getPort(EntityService.class);
        }
        return this.entityService;
    }

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        table.setSelectionMode(0);
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit(table, this);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> Async.of(() -> this.model.setData(this.getEntityService().entitySpecAttrList())));
        new AbstractBGUPanel.BGActionNew(e -> new EntitySpecAttrEditor("\u041d\u043e\u0432\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442", new EntitySpecAttr()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.showEditDialog(this.model, EntitySpecAttrEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430"));
        new AbstractBGUPanel.BGActionDelete(e -> {
            EntitySpecAttr entitySpecAttr = (EntitySpecAttr)this.model.getSelectedRow();
            if (entitySpecAttr != null && BGSwingUtilites.confirmDelete("\u0430\u0442\u0440\u0438\u0431\u0443\u0442", entitySpecAttr)) {
                this.getEntityService().entitySpecAttrDelete(entitySpecAttr.getId());
                this.performAction("refresh");
            }
        });
    }

    public class EntitySpecAttrEditor
    extends BGEditorDialog<EntitySpecAttr> {
        private BGUComboBox<IdTitle> type;
        private BGTextField title;
        private JTextArea comment;

        public EntitySpecAttrEditor(String title, EntitySpecAttr data) {
            super(title, data);
            this.type = new BGUComboBox();
            this.title = new BGTextField();
            this.comment = new JTextArea(4, 50);
        }

        @Override
        public void doDialogPanel() {
            ArrayList<IdTitle> listData = new ArrayList<IdTitle>();
            listData.add(new IdTitle(EntitySpecAttrType.TEXT.getCode(), "\u0422\u0435\u043a\u0441\u0442"));
            listData.add(new IdTitle(EntitySpecAttrType.INT.getCode(), "\u0427\u0438\u0441\u043b\u043e"));
            listData.add(new IdTitle(EntitySpecAttrType.LIST.getCode(), "\u0421\u043f\u0438\u0441\u043e\u043a"));
            listData.add(new IdTitle(EntitySpecAttrType.DATE.getCode(), "\u0414\u0430\u0442\u0430"));
            listData.add(new IdTitle(EntitySpecAttrType.ADDRESS.getCode(), "\u0410\u0434\u0440\u0435\u0441"));
            this.type.setData(listData);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add(this.type, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.type.setSelectedItem(((EntitySpecAttr)this.data).getType());
            this.type.setEnabled(((EntitySpecAttr)this.data).getId() < 1);
            this.title.setText(((EntitySpecAttr)this.data).getTitle());
            this.comment.setText(((EntitySpecAttr)this.data).getComment());
        }

        @Override
        public boolean doApply() throws Exception {
            ((EntitySpecAttr)this.data).setTitle(this.title.getText());
            ((EntitySpecAttr)this.data).setType(((IdTitle)this.type.getSelectedItem()).getId());
            ((EntitySpecAttr)this.data).setComment(this.comment.getText());
            int id = EntitySpecAttrPanel.this.getEntityService().entitySpecAttrUpdate((EntitySpecAttr)this.data);
            EntitySpecAttrPanel.this.performAction("refresh");
            EntitySpecAttrPanel.this.model.setSelectedRow(id);
            return true;
        }
    }
}

