/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class StatusTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<?>, TariffContext> {
    private List<Integer> statusIds = new ArrayList<Integer>();

    public StatusTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.statusIds = Utils.toIntegerList(parameterMap.get("status", ""));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int executeImpl(Long treeNodeId, AbstractTariffRequest<?> tariffRequest, TariffContext tariffContext) {
        int contractId = tariffRequest.contractId;
        try (ContractStatusDao contractStatusDao = new ContractStatusDao(tariffRequest.getConnection());){
            LocalDate date = TimeUtils.convertDateToLocalDate(tariffRequest.getTime().getTime());
            ContractStatus contractStatus = contractStatusDao.getStatus(contractId, tariffRequest.getObjectId(), date);
            if (contractStatus == null) return 0;
            if (!this.statusIds.contains(contractStatus.getStatus())) return 0;
            int n = 1;
            return n;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        return 0;
    }
}

