/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.log.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class LogManagerPanel
extends JPanel {
    protected int cursorX = 1;
    protected int cursorY = 0;
    protected int cursorStartX = 1;
    protected int cursorStartY = 0;
    protected int pX = 1;
    protected int pY = 0;
    protected int selectAreaW = 1;
    protected int selectAreaH = 1;
    protected int size = 20;
    protected int indent = 5;
    protected int ruleWidth = 20;
    protected int zeroPointSize = 4;
    private int graphWidth = 0;
    private int graphHeight = 0;
    private Font ruleFont = new Font("", 0, 10);
    private Font dataFont = new Font("", 1, 12);
    protected JPopupMenu popup = new JPopupMenu();
    private boolean[] checkboxes = new boolean[]{true, true, true, true, true, true};
    private int[][] values;
    private int[] quads = new int[31];
    private int valueCount = 0;
    private int[] colors;
    protected int days = 31;
    protected ActionListener popupListener = null;

    public LogManagerPanel(int valueCount, int[] colors) {
        this.valueCount = valueCount;
        this.colors = colors;
        this.values = new int[valueCount][31];
        this.calculateSizes(this.days);
        this.enableEvents(56L);
        this.popupListener = e -> this.popupMenu_actionPerformed((JMenuItem)e.getSource());
    }

    public void clearPopups() {
        this.popup.removeAll();
    }

    public void addPopupSeparator() {
        this.popup.addSeparator();
    }

    public void addMenuItem(String name, String action) {
        JMenuItem item = new JMenuItem(name);
        item.setActionCommand(action);
        item.addActionListener(this.popupListener);
        this.popup.add(item);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() != 506) {
            super.processMouseMotionEvent(e);
            return;
        }
        Point p = e.getPoint();
        int x = p.x - this.indent - this.ruleWidth;
        int y = p.y - this.ruleWidth;
        if (x > 0 && x < this.days * this.size && y > 0 && y < 24 * this.size) {
            boolean fl = false;
            x = x / this.size + 1;
            y /= this.size;
            if (this.pX != x) {
                if (x - this.cursorStartX >= 0) {
                    this.selectAreaW = x - this.cursorStartX + 1;
                    this.cursorX = this.cursorStartX;
                } else {
                    this.selectAreaW = this.cursorStartX - x + 1;
                    this.cursorX = x;
                }
                this.pX = x;
                fl = true;
            }
            if (this.pY != y) {
                if (y - this.cursorStartY >= 0) {
                    this.selectAreaH = y - this.cursorStartY + 1;
                    this.cursorY = this.cursorStartY;
                } else {
                    this.selectAreaH = this.cursorStartY - y + 1;
                    this.cursorY = y;
                }
                this.pY = y;
                fl = true;
            }
            if (fl) {
                this.repaint();
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        this.repaint();
        if (e.getID() != 501) {
            return;
        }
        Point p = e.getPoint();
        int mods = e.getModifiers();
        if ((mods & 0x10) > 0) {
            int x = p.x - this.indent - this.ruleWidth;
            int y = p.y - this.ruleWidth;
            if (x > 0 && x < this.days * this.size && y > 0 && y < 24 * this.size) {
                this.selectAreaW = 1;
                this.selectAreaH = 1;
                this.cursorStartX = this.cursorX = x / this.size + 1;
                this.cursorStartY = this.cursorY = y / this.size;
                this.repaint();
            }
        } else if ((mods & 4) > 0 && !this.popup.isPopupTrigger(e)) {
            this.popup.show(e.getComponent(), p.x, p.y);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    private void popupMenu_actionPerformed(JMenuItem item) {
        String actionCommand = item.getActionCommand();
        this.firePropertyChange(actionCommand, "", item);
        this.repaint();
    }

    public void setData(int[][] values, int[] quads, int days) {
        this.values = values;
        this.quads = quads;
        this.days = days;
        this.calculateSizes(days);
        this.repaint();
    }

    protected void calculateSizes(int days) {
        this.graphWidth = days * this.size + this.ruleWidth;
        this.graphHeight = 24 * this.size + this.ruleWidth;
        this.setPreferredSize(new Dimension(this.graphWidth + 2 * this.indent, this.graphHeight + 4 * this.indent));
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String text = super.getToolTipText(e);
        return text;
    }

    public Rectangle getSelectArea() {
        return new Rectangle(this.cursorX, this.cursorY, this.selectAreaW, this.selectAreaH);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(UIManager.getColor("Panel.background"));
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.white);
        for (int d = 1; d < this.days + 1; ++d) {
            for (int h = 0; h < 24; ++h) {
                int k = 1 << h;
                int color = 0;
                for (int i = 0; i < this.valueCount; ++i) {
                    color |= (this.values[i][d - 1] & k) > 0 && this.checkboxes[i] ? this.colors[i] : 0;
                }
                g.setColor(color == 0 ? Color.WHITE : (color == Color.WHITE.getRGB() ? Color.LIGHT_GRAY : new Color(color)));
                g.fillRect(this.indent + this.ruleWidth + this.size * (d - 1), this.ruleWidth + this.size * h, this.size, this.size);
                if ((this.quads[d - 1] & k) <= 0 || !this.checkboxes[5]) continue;
                int pointOffset = (this.size - this.zeroPointSize) / 2;
                g.setColor(Color.RED);
                g.fillRect(this.indent + this.ruleWidth + this.size * (d - 1) + pointOffset + 1, this.ruleWidth + this.size * h + pointOffset + 1, this.zeroPointSize, this.zeroPointSize);
            }
        }
        g.setFont(this.ruleFont);
        FontMetrics FM = g.getFontMetrics();
        g.setColor(Color.black);
        for (int x = 0; x < this.days + 1; ++x) {
            int x1 = this.indent + this.ruleWidth + x * this.size;
            g.drawLine(x1, this.ruleWidth, x1, this.graphHeight);
            if (x <= 0) continue;
            g.drawString("" + x, x1 - this.size / 2 - FM.stringWidth("" + x) / 2, this.ruleWidth - FM.getDescent());
        }
        for (int y = 0; y < 25; ++y) {
            int y1 = this.ruleWidth + y * this.size;
            g.drawLine(this.indent + this.ruleWidth, y1, this.indent + this.graphWidth, y1);
            if (y >= 24) continue;
            String label = y < 10 ? "0" + y : "" + y;
            g.drawString(label, this.indent + this.ruleWidth - FM.getDescent() - FM.stringWidth(label), this.ruleWidth + y * this.size + this.size / 2 + FM.getAscent() / 2 - FM.getLeading());
        }
        g.drawRect(this.indent + this.ruleWidth + this.size * (this.cursorX - 1) - 1, this.ruleWidth + this.size * this.cursorY - 1, this.selectAreaW * this.size + 2, this.selectAreaH * this.size + 2);
        g.setFont(this.dataFont);
    }

    public void setViewMode(boolean[] checkboxes) {
        this.checkboxes = checkboxes;
        this.repaint();
    }

    public List<Date> getSelectedDays(Calendar month) {
        ArrayList<Date> days = new ArrayList<Date>();
        Rectangle rect = this.getSelectArea();
        for (int i = rect.x; i < rect.x + rect.width; ++i) {
            month.set(5, i);
            days.add(month.getTime());
        }
        return days;
    }
}

