/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.event.AbstractConsumer;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;

public abstract class AbstractExecutorEventWorker
implements EventListener<Event>,
MessageListener,
Lifecycle {
    private Logger logger;
    protected final AbstractConsumer consumer;
    protected final int moduleId;

    public AbstractExecutorEventWorker(EventProcessor ep, Class<? extends Event> clazz, int moduleId, int pluginId, String query) throws BGException {
        try {
            this.moduleId = moduleId;
            this.consumer = ep.newConsumer(clazz, moduleId, pluginId, query);
            this.consumer.listenerAdd(this);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public AbstractExecutorEventWorker(EventProcessor ep, String destination, int moduleId, int pluginId, String query, Class<?> ... clazz) throws BGException {
        try {
            this.moduleId = moduleId;
            this.consumer = ep.newConsumer(destination, moduleId, pluginId, query, true, false, 2, 4, 0L, clazz);
            this.consumer.listenerAdd(this);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    public void start() throws BGException {
        try {
            this.consumer.mc.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            throw new BGException(e);
        }
    }

    @Override
    public void stop() throws BGException {
        this.shutdown();
    }

    public void shutdown() throws BGException {
        this.getLogger().info("shutdown");
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw new BGException(e);
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogManager.getLogger((String)this.getClass().getName());
        }
        return this.logger;
    }
}

