/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.admin.UserAuthR;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStop;

public class BGClientR
extends BGClientBase {
    public BGClientR() {
        this(null, null, true);
    }

    public BGClientR(String dbInfoKey, String dbAuth, boolean showAboutDialog) {
        this.init1(showAboutDialog);
        DBInfo dbInfo = this.dbInfoManager.getInfo(dbInfoKey);
        if (dbAuth != null) {
            String[] auth = BGClientRunnerCipher.cipher(dbAuth, true).split("\t", -1);
            dbInfo.setDbServerLogin(auth[0]);
            dbInfo.setDbServerPassword(auth[1]);
        }
        if (dbInfo != null) {
            this.dbInfoManager.connect(dbInfo);
        }
        while ((dbInfo = this.auth(dbInfo)) != null) {
        }
        this.init2();
    }

    @Override
    public DBInfo auth(DBInfo dbInfo) {
        super.auth(dbInfo);
        if (dbInfo != null && this.dbInfoManager.isAutorized(dbInfo)) {
            this.switchServer(dbInfo);
            return null;
        }
        UserAuthR userAuthDialog = new UserAuthR();
        if (dbInfo != null) {
            userAuthDialog.setDbInfo(dbInfo);
        } else if (this.dbInfoManager.getDefaultServerKey() != null) {
            userAuthDialog.setDbInfo(this.dbInfoManager.getInfo(this.dbInfoManager.getDefaultServerKey()));
        }
        userAuthDialog.setData();
        if (userAuthDialog.showDialog() == "cancel") {
            DBInfo dbActive = this.dbInfoManager.getActiveDBInfo();
            if (dbActive == null) {
                BGClientR.close();
            } else {
                this.setBarData(dbActive);
            }
            return null;
        }
        if (this.dbInfoManager.getActiveDBInfo() != null) {
            for (OnStop p : BGPluginManagerClient.getManager().getInvokeables(OnStop.class, false)) {
                p.onStop();
            }
        }
        if (!this.dbInfoManager.connect(dbInfo = userAuthDialog.getDbInfo())) {
            return dbInfo;
        }
        this.getTabbedPane().removeAll();
        this.dbInfoManager.setActiveDBInfo(dbInfo);
        BGClientR.loadUserEmail(dbInfo);
        return this.auth5(dbInfo);
    }

    public static void main(String[] args) {
        BGClientInit.mainInit(args);
        String dbInfoKey = null;
        String dbInfoAuth = null;
        for (String arg : args) {
            if (arg.startsWith("dbInfo=")) {
                dbInfoKey = arg.substring(7);
                continue;
            }
            if (!arg.startsWith("dbAuth=")) continue;
            dbInfoAuth = arg.substring(7);
        }
        new BGClientR(dbInfoKey, dbInfoAuth, true);
    }

    @Override
    protected void jbInit() throws Exception {
        super.jbInit(true);
    }
}

