/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.common.Utils;

public class ServerCommandWorker {
    private static final String PREFIX_OPEN_CONTRACT = "openContract:";
    private static final String PREFIX_OPEN_CONTRACT_BY_TITLE = "openContractByTitle:";
    private static final int OPEN_CONTRACT_PREFIX_LENGTH = "openContract:".length();

    public static void doCommands(BGClientBase frame, DBInfoManager dbInfoManager) {
        for (DBInfo dbInfo : dbInfoManager.getInfoLists()) {
            if (!dbInfoManager.isAutorized(dbInfo)) continue;
            TransferData transferData = dbInfo.getTransferData();
            Request request = new Request();
            request.setModule("admin");
            request.setAction("Command");
            request.setAttribute("command", "get");
            try {
                transferData.postData(request);
                Document doc = transferData.getDocument();
                String value = doc.getDocumentElement().getAttribute("value");
                if (!Utils.notBlankString(value)) continue;
                if (value.startsWith(PREFIX_OPEN_CONTRACT)) {
                    ServerCommandWorker.openContractTab(Utils.parseInt(value.substring(OPEN_CONTRACT_PREFIX_LENGTH)), frame, dbInfo);
                    break;
                }
                if (!value.startsWith(PREFIX_OPEN_CONTRACT_BY_TITLE)) continue;
                Contract contract = new ClientContext("contract", 0, 0, null).getWebService(ContractService.class).contractByTitle(value.substring(PREFIX_OPEN_CONTRACT_BY_TITLE.length()));
                if (contract == null) break;
                ServerCommandWorker.openContractTab(contract.getId(), frame, dbInfo);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void openContractTab(int contractId, BGClientBase frame, DBInfo dbInfo) {
        if (contractId > 0) {
            frame.auth(dbInfo);
            frame.getTabbedPane().addContractEditorTab(contractId);
        }
    }
}

