/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.domain.server.tariff;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntime;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;

public class DomainFilterTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private static final Logger logger = LogManager.getLogger();
    private final Set<Integer> domainIds;
    private final List<AtomicReference<DomainRuntime>> domains;

    public DomainFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.domainIds = new HashSet<Integer>(Utils.toIntegerList((String)parameterMap.get("domainIds", "")));
        this.domains = new ArrayList<AtomicReference<DomainRuntime>>(this.domainIds.size());
        try {
            DomainRuntimeMap domainRuntimeMap = DomainRuntimeMap.getInstance();
            for (Integer domainId : this.domainIds) {
                AtomicReference<DomainRuntime> ref = domainRuntimeMap.getRef(domainId);
                if (ref == null) continue;
                this.domains.add(ref);
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        Set<Long> acceptedSet = req.getAcceptedSet(DomainFilterTariffTreeNode.class);
        if (this.domainIds.size() == 0) {
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        if (acceptedSet.contains(parentTreeNodeId)) {
            return 0;
        }
        if (this.domainIds.contains(req.getDomainId())) {
            acceptedSet.add(parentTreeNodeId);
            return 1;
        }
        for (AtomicReference<DomainRuntime> ref : this.domains) {
            DomainRuntime domainRuntime = ref.get();
            if (domainRuntime == null || !domainRuntime.getDescendantIds().contains(req.getDomainId())) continue;
            acceptedSet.add(parentTreeNodeId);
            return 1;
        }
        return 0;
    }
}

