/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.DatabaseClassLoader;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptUpdatedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;

public class ReadOnlyClassManager
extends DynamicClassManager {
    public ReadOnlyClassManager(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    @Override
    protected void addListeners() throws BGException {
        EventProcessor.getInstance().addListener(new EventListener<ScriptUpdatedEvent>(){

            @Override
            public void notify(ScriptUpdatedEvent e, EventListenerContext ctx) throws BGException {
                try {
                    ReadOnlyClassManager.this.flushLoadedClassCache();
                    DatabaseClassLoader loader = new DatabaseClassLoader(ReadOnlyClassManager.this.parentClassLoader);
                    for (String className : e.getClassNames()) {
                        ReadOnlyClassManager.this.addLoadedClass(className, loader.loadClass(className));
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
        }, ScriptUpdatedEvent.class);
    }
}

