/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server.searchimpl;

import jakarta.xml.ws.Holder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractSearchableFilters;
import ru.bitel.bgbilling.kernel.contract.search.server.AbstractContractSearchable;
import ru.bitel.common.model.Page;

public class SearchContractsByEmail
extends AbstractContractSearchable {
    private final String CONTRACT_STATUS = "status";

    @Override
    public boolean check(String searchData) {
        return searchData != null && !searchData.trim().isEmpty() && searchData.contains("@");
    }

    @Override
    public List<JSONObject> search(String searchData, int moduleId, ContractSearchableFilters filters, Holder<Page> pageHolder) throws BGException {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection con = serverContext.getConnection();
        HashSet<Integer> cids = new HashSet<Integer>();
        try (PreparedStatement psSelect = con.prepareStatement("SELECT * FROM contract_parameter_type_3 WHERE INSTR(email,?)");){
            psSelect.setString(1, searchData);
            try (ResultSet resultSet = psSelect.executeQuery();){
                while (resultSet.next()) {
                    cids.add(resultSet.getInt("cid"));
                    if (cids.size() <= 20) continue;
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        try (ContractDao contractDao = new ContractDao(con, serverContext.getUserId());
             BalanceUtils balanceUtils = new BalanceUtils(con);){
            for (Integer cid : cids) {
                Contract contract = (Contract)contractDao.get(cid);
                if (contract == null || !filters.isShowSubContracts() && contract.isSub() || !filters.isShowHidden() && contract.isHidden()) continue;
                result.add(this.convertJSONFromContract(contract, balanceUtils));
            }
        }
        return result;
    }

    @Override
    public String getTitle() {
        return "\u041f\u043e\u0438\u0441\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043f\u043e Email \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (\u043f\u043e\u043b\u043d\u043e\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u0430)";
    }

    private JSONObject convertJSONFromContract(Contract contract, BalanceUtils balanceUtils) {
        JSONObject object = new JSONObject();
        object.put("cid", contract.getId());
        object.put("contractTitle", (Object)contract.getTitle());
        object.put("status", (int)contract.getStatus());
        object.put("color", (Object)(contract.getStatus() > 0 ? "red" : ""));
        object.put("balance", (Object)balanceUtils.getBalance(LocalDate.now(), contract.getId()));
        return object;
    }
}

