/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.gorod.server.bean.Register;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class RegisterManager {
    protected int mid = -1;
    protected Connection con;

    public RegisterManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
    }

    public Register getRegisterById(int id) {
        Register result = null;
        try {
            String query = "SELECT * FROM gorod_register_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Register();
                result.setTagId(rs.getInt("tid"));
                result.setType(rs.getInt("type"));
                result.setDate(TimeUtils.convertDateToCalendar((Date)rs.getDate("dt")));
                result.setId(rs.getInt("id"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public Register getRegisterByID(int id) {
        return this.getRegisterById(id);
    }

    public void addRegister(Register register) {
        try {
            String query = "INSERT INTO gorod_register_" + this.mid + " SET dt=?, type=?, tid=?";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)register.getDate()));
            ps.setInt(2, register.getType());
            ps.setInt(3, register.getTagId());
            ps.executeUpdate();
            register.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Register> getRegisterList(Calendar date1, Calendar date2) {
        ArrayList<Register> result = new ArrayList<Register>();
        try {
            String query = "SELECT * FROM gorod_register_" + this.mid + " WHERE (? IS NULL OR ?<=dt) AND (? IS NULL OR ?>=dt) ORDER BY dt";
            PreparedStatement ps = this.con.prepareStatement(query);
            java.sql.Date sqlDate1 = TimeUtils.convertCalendarToSqlDate((Calendar)date1);
            java.sql.Date sqlDate2 = TimeUtils.convertCalendarToSqlDate((Calendar)date2);
            ps.setDate(1, sqlDate1);
            ps.setDate(2, sqlDate1);
            ps.setDate(3, sqlDate2);
            ps.setDate(4, sqlDate2);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Register register = new Register();
                this.loadRegisterFromRS(rs, register);
                result.add(register);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Register getRegister(int type, Calendar date, int tagID) {
        Register result = null;
        try {
            String query = "SELECT * FROM gorod_register_" + this.mid + " WHERE dt=? AND type=? AND tid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setInt(2, type);
            ps.setInt(3, tagID);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Register();
                this.loadRegisterFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteRegister(int id) {
        try {
            String query = "DELETE FROM gorod_register_item_" + this.mid + " WHERE rid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM gorod_register_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadRegisterFromRS(ResultSet rs, Register register) throws SQLException {
        register.setId(rs.getInt("id"));
        register.setDate(TimeUtils.convertDateToCalendar((Date)rs.getDate("dt")));
        register.setType(rs.getInt("type"));
        register.setTagId(rs.getInt("tid"));
    }
}

