/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import java.util.List;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountAttributeManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValue;
import ru.bitel.bgbilling.modules.email.server.bean.DefaultLDAPDriver;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;

public class EximLDAPDriver
extends DefaultLDAPDriver {
    @Override
    protected String getAccountDN(Account account) {
        StringBuffer result = new StringBuffer(100);
        result.append("mailBox=");
        result.append(account.getAccount());
        result.append("@");
        result.append(this.domain.getName());
        result.append(",");
        result.append(this.params.get("root", "dc=mydomain, dc=ru"));
        return result.toString();
    }

    @Override
    protected LDAPAttributeSet getAccountAttributeSet(Account account) {
        String[] pairs;
        String statusLabel = account.getStatus() == 0 ? "enabled" : "disabled";
        LDAPAttributeSet attributes = new LDAPAttributeSet();
        attributes.add((Object)new LDAPAttribute("objectClass", "mailAccount"));
        attributes.add((Object)new LDAPAttribute("mailBox", account.getAccount() + "@" + this.domain.getName()));
        attributes.add((Object)new LDAPAttribute("status", statusLabel));
        attributes.add((Object)new LDAPAttribute("boxQuota", String.valueOf(account.getQuota())));
        attributes.add((Object)new LDAPAttribute("userPassword", String.valueOf(account.getPassword())));
        attributes.add((Object)new LDAPAttribute("base", this.params.get("base", "bgbilling")));
        AccountAttributeManager attributeManager = new AccountAttributeManager(this.params);
        List<AttributeValue> valueList = account.getAttributes();
        for (AttributeValue value : valueList) {
            String[] attr = attributeManager.getAttributeMap().get(value.getAttributeId());
            if (attr == null) continue;
            attributes.add((Object)new LDAPAttribute(attr.getName(), value.getAttributeValue()));
        }
        String addAttributes = this.params.get("addattr", "");
        for (String pair : pairs = addAttributes.split("\\s*;\\s*")) {
            String[] attribute = pair.split("\\s*:\\s*");
            if (attribute.length != 2) continue;
            String name = attribute[0];
            String value = attribute[1];
            value = value.replaceAll("\\$DOMAIN", this.domain.getName());
            value = value.replaceAll("\\$ACCOUNT", account.getAccount());
            attributes.add((Object)new LDAPAttribute(name, value));
        }
        List<Forward> forwardList = account.getForwardList();
        if (forwardList.size() > 0) {
            int i = 0;
            String[] forwardArray = new String[forwardList.size()];
            for (Forward forward : forwardList) {
                forwardArray[i++] = forward.getEmail();
            }
            attributes.add((Object)new LDAPAttribute("forward", forwardArray));
        }
        return attributes;
    }
}

