/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.action.web;

import bitel.billing.server.ActionBase;
import bitel.billing.server.ActionConType;
import bitel.billing.server.ActionResultContentType;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsFileStorage;
import ru.bitel.common.util.FileDownload;

@ActionConType(value=2)
public class ActionFileDownload
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int fileId = this.getIntParameter("id", -1);
        if (fileId > 0) {
            DocumentsFileStorage fileStorage = new DocumentsFileStorage(this.con);
            BGServerFile serverFile = fileStorage.getFileById(fileId);
            if (serverFile == null) {
                this.request.setAttribute("contentType", (Object)ActionResultContentType.jsp);
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
            }
            try (DocumentDao documentManager = new DocumentDao(this.con);){
                int fileCid = documentManager.getDocumentOwnerId(serverFile.getOwnerId());
                if (fileCid != this.cid) {
                    throw new BGMessageException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442!");
                }
            }
            try {
                this.request.setAttribute("contentType", (Object)"binary");
                this.response.setContentType("application/octet-stream");
                this.response.setHeader("Content-Disposition", FileDownload.getContentDisposition((HttpServletRequest)this.request, (String)serverFile.getTitle(), (boolean)false));
                ServletOutputStream out = this.response.getOutputStream();
                fileStorage.loadStream(fileId, (OutputStream)out);
                out.close();
            }
            catch (FileNotFoundException e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).\n" + e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 OutputStream.\n" + e.getLocalizedMessage());
            }
        }
    }
}

