/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.auth.AuthModes;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.common.TimeUtils;

public class ModuleAuthImpl
extends bitel.billing.server.call.ModuleAuthImpl {
    private Logger logger = LogManager.getLogger();

    public ModuleUser findModuleUserByLogin(String login, int moduleId, int authMode, Connection con) {
        ModuleUser moduleUser = null;
        if (login != null && login.trim().length() > 0 && moduleId > -1) {
            if (authMode == 2) {
                ResultSet rs;
                PreparedStatement ps;
                Date now = new Date();
                int loginId = 0;
                String query = "SELECT lid FROM log_session_" + moduleId + "_" + TimeUtils.format((Date)now, (String)"yyyyMM") + " WHERE ipaddr=? AND status=0";
                try {
                    ps = con.prepareStatement(query);
                    try {
                        ps.setLong(1, IPUtils.convertStringIPtoLong((String)login));
                        rs = ps.executeQuery();
                        try {
                            while (rs.next()) {
                                if (loginId > 0) {
                                    throw new BGException("Dublicate session for IP = " + login);
                                }
                                loginId = rs.getInt(1);
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
                if (loginId > 0) {
                    query = "SELECT contract.id, contract.title FROM user_login_" + moduleId + " AS login INNER JOIN contract ON login.cid=contract.id WHERE login.id=?";
                    try {
                        ps = con.prepareStatement(query);
                        try {
                            ps.setInt(1, loginId);
                            rs = ps.executeQuery();
                            try {
                                if (rs.next()) {
                                    moduleUser = ModuleUser.builder().setContractId(rs.getInt(1)).setContractTitle(rs.getString(2)).setPassword(AuthModes.passwordless()).build();
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)ex);
                    }
                }
            } else {
                moduleUser = super.findModuleUserByLogin(login, moduleId, authMode, con);
            }
        }
        return moduleUser;
    }
}

