/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client.tariff;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class PacketGroupTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"filter.gif");
    private JLabel view;
    private Directory packetDir;
    private List<Integer> values = new ArrayList<Integer>();
    private List<Integer> autoaddPackets = new ArrayList<Integer>();
    private JPanel editor;
    private BGControlPanelListSelect packets;
    private BGControlPanelListSelect autoaddList;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.packetDir = this.getDirManager().getDirectory("packets");
    }

    protected JPanel getEditorPanel() {
        return new JPanel();
    }

    public Component getEditor() {
        if (this.editor == null) {
            this.editor = new JPanel(new GridBagLayout());
            this.editor.setMinimumSize(new Dimension(400, 500));
            this.editor.setPreferredSize(new Dimension(400, 500));
            this.packets = new BGControlPanelListSelect();
            this.autoaddList = new BGControlPanelListSelect();
            this.autoaddList.setEnabled(false);
            for (IdTitle di : this.packetDir.getItems()) {
                this.packets.getListModel().addElement(new BGUListItem(di.getId(), di.getTitle()));
                this.autoaddList.getListModel().addElement(new BGUListItem(di.getId(), di.getTitle()));
            }
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("ok")) {
                        PacketGroupTariffTreeNode.this.serializeData();
                        PacketGroupTariffTreeNode.this.saveData();
                    }
                    PacketGroupTariffTreeNode.this.tree.getViewableTree().stopEditing();
                }
            });
            this.editor.add((Component)new JLabel("\u0411\u0430\u0437\u043e\u0432\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.packets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)new JLabel("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u044e\u0442\u0441\u044f (\u0423\u0421\u0422\u0410\u0420\u0415\u041b\u041e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0443\u0437\u0435\u043b \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u044b\u0445):"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.autoaddList, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)okCancel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        return this.editor;
    }

    protected void loadData() {
        this.extractData();
        this.getEditor();
        this.packets.setListValues(Utils.toString(this.values));
        this.autoaddList.setListValues(Utils.toString(this.autoaddPackets));
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("packets", this.packets.getListValues());
        data.put("autoadd_packets", this.autoaddList.getListValues());
        this.setDataInHash(data);
    }

    public Component getView() {
        String packetTitle;
        if (this.view == null) {
            this.view = new JLabel();
            this.view.setIcon(icon);
        }
        this.extractData();
        ArrayList<Integer> autoaddPacketsNotBase = new ArrayList<Integer>(this.autoaddPackets);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\u0411\u0430\u0437\u043e\u0432\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b:");
        for (Integer code : this.values) {
            packetTitle = this.packetDir.getValue(code.intValue());
            if (packetTitle == null) continue;
            sb.append("<br>");
            sb.append(packetTitle);
            if (!this.autoaddPackets.contains(code)) continue;
            autoaddPacketsNotBase.remove(code);
            sb.append(" (\u0430\u0432\u0442\u043e\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435, \u0423\u0421\u0422\u0410\u0420\u0415\u041b\u041e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0443\u0437\u0435\u043b \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u044b\u0445)");
        }
        for (Integer code : autoaddPacketsNotBase) {
            packetTitle = this.packetDir.getValue(code.intValue());
            if (packetTitle == null) continue;
            sb.append("<br>\u041f\u0440\u043e\u0441\u0442\u043e \u0430\u0432\u0442\u043e\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 (\u0423\u0421\u0422\u0410\u0420\u0415\u041b\u041e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0443\u0437\u0435\u043b \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u044b\u0445): ").append(packetTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.values.clear();
        this.values.addAll(Utils.toIntegerList((String)((String)data.get("packets"))));
        this.autoaddPackets.clear();
        this.autoaddPackets.addAll(Utils.toIntegerList((String)((String)data.get("autoadd_packets"))));
    }
}

