/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.common.Utils;

public class ContractDocTypeManager {
    private Connection con;
    private String tableName;
    private String docTypeTableName;

    public ContractDocTypeManager(Connection con, int moduleId) {
        this.con = con;
        this.tableName = "bill_contract_doc_type_" + moduleId;
        this.docTypeTableName = "bill_doc_type_" + moduleId;
    }

    public ContractDocType getContractDocType(int id) {
        ContractDocType result = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE id=?");){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getDocTypeFromRs(rs);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ContractDocType> getContractTypeList(int contractId, DocumentType documentType, String docTypes) {
        ArrayList<ContractDocType> result = new ArrayList<ContractDocType>();
        try {
            String query = "SELECT * FROM " + this.tableName + " AS contract_type INNER JOIN " + this.docTypeTableName + " AS doc_type ON contract_type.doc_type=doc_type.id WHERE contract_type.cid=? AND doc_type.type=?";
            if (Utils.notBlankString((String)docTypes)) {
                query = query + " AND contract_type.doc_type IN ( " + docTypes + ")";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, documentType.getCode());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getDocTypeFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<DocType> getContractDocTypeList(int contractId, DocumentType documentType) {
        ArrayList<DocType> result = new ArrayList<DocType>();
        try {
            String query = "SELECT doc_type.* FROM " + this.tableName + " AS contract_type INNER JOIN " + this.docTypeTableName + " AS doc_type ON contract_type.doc_type=doc_type.id WHERE contract_type.cid=? AND doc_type.type=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, documentType.getCode());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(DocTypeManager.getTypeFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void addContractType(ContractDocType contractType) {
        try {
            String query = "INSERT INTO " + this.tableName + "( doc_type, cid ) VALUES (?, ?)";
            PreparedStatement insertContractDocType = this.con.prepareStatement(query);
            insertContractDocType.setInt(1, contractType.getDocTypeId());
            insertContractDocType.setInt(2, contractType.getContractId());
            insertContractDocType.executeUpdate();
            insertContractDocType.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkDocTypeExist(ContractDocType contractType) {
        try {
            String query = "SELECT id FROM " + this.tableName + " WHERE cid=? AND doc_type=?";
            PreparedStatement getContractDocTypePS = this.con.prepareStatement(query);
            getContractDocTypePS.setInt(1, contractType.getContractId());
            getContractDocTypePS.setInt(2, contractType.getDocTypeId());
            ResultSet rs = getContractDocTypePS.executeQuery();
            boolean result = rs.next();
            getContractDocTypePS.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void deleteContractType(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteContractType(int cid, int docType) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE cid=? AND doc_type=? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, docType);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ContractDocType getDocTypeFromRs(ResultSet rs) throws SQLException {
        ContractDocType result = new ContractDocType();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setDocTypeId(rs.getInt("doc_type"));
        return result;
    }
}

