<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<fmt:setLocale value="ru_RU" />

<div id="voiceResult"></div>

<div class="buttons">
	<button class="btn btn-secondary" onclick="showBlock( 'voiceRoot', 'accounts', voiceQuery );">К списку</button></div>
<!-- <div><label for="hdTopicFilterCheckbox"><img title="Фильтр тем" src="${pageContext.request.contextPath}/img/filter.png" height="32"/></label></div>  -->
</div>

<div class="tile">

	<bg:blockTitle title="Детализация сессий"/>

	<div>Аккаунт: <b>${account}</b></div>
	
	<c:choose>
	<c:when test="${not empty orders}">
	<c:forEach var="item" items="${orders}">
		<div class="mTop10" style="margin-left: 1rem;">
			<c:set var="fileSize">
				<c:choose>
					<c:when test="${item.fileSize == 0}"></c:when>
					<c:when test="${item.fileSize < 1048576}">, <fmt:formatNumber groupingUsed="true" maxFractionDigits="0" value="${item.fileSize / 1024}"></fmt:formatNumber>Кб</c:when>
					<c:when test="${item.fileSize < 1073741824}">, <fmt:formatNumber groupingUsed="true" maxFractionDigits="0" value="${item.fileSize / 1048576}"></fmt:formatNumber>Mб</c:when>
				</c:choose>
			</c:set>
			<fmt:parseDate var="orderTitle" value="01.${item.month}.${item.year}" pattern="dd.MM.yyyy" />
			<div class="flexRow">
				<div>
					<div><span style="text-transform: uppercase;"><fmt:formatDate value="${orderTitle}" pattern="LLLL yyyy"/></span> <span class="paramColor paramFont">[${item.formatType}${fileSize}]</span></div>
					<div class="mTop05 paramFont" style="margin-left: 1rem;" >
						<div class="paramColor">Статус:
						<span><c:choose>
							<c:when test="${'WAIT' eq item.status}">ожидает обработки</c:when>
							<c:when test="${'EXECUTE' eq item.status}">в обработке</c:when>
							<c:when test="${'DONE' eq item.status}">завершено</c:when>
							<c:when test="${'ERROR' eq item.status}">ошибка</c:when>
							<c:otherwise>${item.status}</c:otherwise>
						</c:choose></span>
						</div>
						<div class="paramColor">Дата создания: <span><fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="MEDIUM" value="${item.createDate}"/></span></div>
					</div>
				</div>
				<div style="text-align: right;"><c:if test="${'DONE' eq item.status}"><a href="${pageContext.request.contextPath}/data/${moduleId}/session/${item.year}/${item.month}/${accountId}.${fn:toLowerCase(item.formatType)}"><img src="${pageContext.request.contextPath}/img/download.png" class="icon2" title="скачать"/></a></c:if></div>
			</div>
		</div>
	</c:forEach>
	</c:when>
	<c:otherwise><bg:dataNotFound/></c:otherwise>
	</c:choose>
	
	<form>
	<div class="titleFont2 titleBottomLine mTop30" style="margin-bottom: 20px;">Заказать детализацию сессий</div>

	<div class="textFieldLabel mTop10">За период:</div>
	<div class="textField flexRow">
		<select name="month" style="text-align: center; margin-right: 5px;">
			<c:forTokens var="item" items="01 02 03 04 05 06 07 08 09 10 11 12" delims=" ">
				<fmt:parseDate var="m" value="01.${item}.2000" pattern="dd.MM.yyyy" />
				<c:set var="selected"><c:if test="${item eq month}">selected="selected"</c:if></c:set>
				<option value="${item}" ${selected}><fmt:formatDate value="${m}" pattern="LLLL"/> </option>
			</c:forTokens>
		</select> 
		<select name="year" style="text-align: center; margin-left: 5px;">
			<c:forEach var="item" items="${years}">
				<option value="${item}">${item}</option>
			</c:forEach>
		</select>
	</div>	
	
	<div class="textFieldLabel mTop10">Формат отчета:</div>
	<div class="textField"> <select name="format" style="text-align: center;"><option value="PDF">PDF</option><option value="CSV">CSV</option></select> </div>

	<div class="textFieldLabel mTop10">E-mail:</div>
	<div class="textField"><input type="text" name="email" placeholder="name@email.ru" style="text-align: center;"/></div>

	<div class="textFieldLabel mTop10">Оправить на e-mail:</div>
	<div class="textField" style="margin-left: 1rem;">
		<div class="mTop05"><input type="radio" name="emailSend" value="NONE" checked="checked" > не оправлять</div>
		<div class="mTop05"><input type="radio" name="emailSend" value="NOTIFICATION"> уведомление о готовности отчета</div> 
		<div class="mTop05"><input type="radio" name="emailSend" value="REPORT"> файл с отчетом</div>
	</div>
	
	<div class="formButtons"><button class="btn btn-primary" onclick="return doOrder( this.form );" >Отправить заказ</button></div>
	</form>
</div>

<script type="text/javascript">

function doOrder( form )
{
	let query = { ...voiceQuery, accountId: ${accountId}, month: form.month.value, year: form.year.value };
	query.format = form.format.value;
	query.email = form.email.value;
	query.emailSend = form.emailSend.value;
	showBlock( 'voiceResult', 'accountSessionDetailOrder', query );
	return false;
}

</script>