/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountPanel;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;

public class VoiceAccountNumberForm
extends BGUPanel {
    public static final String ACTION_ADDRESS_SELECTED = "address.selected";
    protected PhoneCategoryTreeModel treeModel = new PhoneCategoryTreeModel();
    protected IntTextField maxField = new IntTextField();
    private BGUTreeTable treeTable = new BGUTreeTable((BGTreeTableModel)this.treeModel);
    private BGTextField numberFilter = new BGTextField(15);
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private BGUList<IdTitle> result = new BGUList();
    private ActionListener actionListener = null;
    private VoiceAccountPanel voiceAccountPanel = null;
    private ClientContext context = null;
    AbstractBGUPanel.DefaultAction resources = new AbstractBGUPanel.DefaultAction("number.resource", "\u0420\u0435\u0441\u0443\u0440\u0441\u044b"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            PhoneCategory rootCat = ((PhoneResourceService)VoiceAccountNumberForm.this.context.getWebService(PhoneResourceService.class)).phoneCategoryRoot();
            VoiceAccountNumberForm.this.treeModel.setData(rootCat);
            VoiceAccountNumberForm.this.treeModel.setSelectedRow(0);
            VoiceAccountNumberForm.this.maxField.setValue((long)ClientSetup.getInstance().getUserConfig().getInt("voice.resource.ip.free.max", 100));
            VoiceAccountNumberForm.this.performActionOpen();
        }
    };

    public VoiceAccountNumberForm(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public VoiceAccountNumberForm(ClientContext context, ActionListener listener) {
        this.context = context;
        this.actionListener = listener;
    }

    protected void jbInit() throws Exception {
        this.treeTable.setSelectionMode(0);
        this.treeTable.addTreeSelectionListener(e -> {
            PhoneCategory phoneCategory = (PhoneCategory)this.treeModel.getSelectedRow();
            if (phoneCategory != null) {
                // empty if block
            }
        });
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)new JScrollPane((Component)this.treeTable), (Component)this.createRightPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected JPanel createRightPanel() {
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopSelect(e.getActionCommand().equals("ok")));
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)new JScrollPane((Component)this.result), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        rightPanel.add((Component)okCancel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 0, 0), 0, 0));
        return rightPanel;
    }

    private JPanel getFilterPanel() {
        this.date.setLocalDate(LocalDate.now());
        this.numberFilter.setHorizontalAlignment(0);
        JButton goButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VoiceAccountNumberForm.this.loadData();
                }
                catch (BGException ex) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.numberFilter, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.date, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 15, 0, 5), 0, 0));
        panel.add((Component)this.maxField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)goButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 15, 0, 5), 0, 0));
        return panel;
    }

    protected void setVoiceAccountPanel(VoiceAccountPanel voiceAccountPanel) {
        this.voiceAccountPanel = voiceAccountPanel;
    }

    private void stopSelect(boolean ok) {
        if (ok && this.result.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u043e\u043c\u0435\u0440", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            return;
        }
        if (this.getParent().getComponent(0) instanceof VoiceAccountNumberForm) {
            Window dialogWindow = SwingUtilities.getWindowAncestor(this.getParent().getComponent(0));
            if (ok) {
                this.voiceAccountPanel.createNewCopyVoiceAccount(this.result.getSelectedValuesList().stream().map(e -> Long.valueOf(e.getTitle())).collect(Collectors.toList()));
                dialogWindow.dispose();
            } else {
                dialogWindow.dispose();
            }
        } else {
            this.actionListener.actionPerformed(new ActionEvent((Object)this, 0, ok ? ACTION_ADDRESS_SELECTED : "cancel"));
        }
    }

    public long getSelectedNumber() {
        return this.result.getSelectedValue() != null ? Long.valueOf(((IdTitle)this.result.getSelectedValue()).getTitle()) : 0L;
    }

    protected void loadData() throws BGException {
        PhoneCategory category = (PhoneCategory)this.treeModel.getSelectedRow();
        if (category == null || category.getId() == 0) {
            throw new BGException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e ");
        }
        if (this.date.getDateCalendar() == null) {
            throw new BGMessageException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0430\u0442\u0443 ");
        }
        this.result.setData(((PhoneResourceService)this.context.getWebService(PhoneResourceService.class)).phoneFreeList(Integer.valueOf(category.getId()), null, this.date.getDate(), this.numberFilter.getText(), (int)this.maxField.getValue()).stream().map(e -> new IdTitle(0, String.valueOf(e))).collect(Collectors.toList()));
    }

    class PhoneCategoryTreeModel
    extends BGTreeTableModel<PhoneCategory> {
        public PhoneCategoryTreeModel() {
            super(PhoneCategoryTreeModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", PhoneCategory.class, -1, 300, -1, "title", false);
            this.addColumnId();
        }
    }
}

