/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxCharge;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxClientPairData;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxTariff;
import ru.bitel.bgbilling.modules.vidimax.common.service.VidimaxService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;

public class UserTransactionsPanel
extends BGUPanel {
    private int contractId;
    private ChargeModel model = new ChargeModel("transactions");
    private BGUTable table = new BGUTable((TableModel)((Object)this.model));
    private TariffModel tariffModel = new TariffModel("tariff");
    private BGUTable tariffTable = new BGUTable((TableModel)((Object)this.tariffModel));
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private BGTextField customerIdField = new BGTextField(20);
    private BGButton customerDataSaveButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    private BGButton customerDataDeleteButton = new BGButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
    private JScrollPane activeTariffScrollPane = new JScrollPane((Component)this.tariffTable);
    private BGControlPanelListSelect avaliableTariffList = new BGControlPanelListSelect();
    private Map<Integer, String> tariffTitleMap;
    private Map<Integer, IdTitle> serviceMap;
    private BGTitleBorder tariffBorder = new BGTitleBorder("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b");
    VidimaxClientPairData pairData;
    VidimaxService service;

    protected void jbInit() {
        this.contractId = ((ClientContext)this.getContext()).getContractId();
        this.service = (VidimaxService)((ClientContext)this.getContext()).getPort(VidimaxService.class);
        JButton okButton = new JButton("OK");
        JPanel choosePanel = new JPanel(new GridBagLayout());
        choosePanel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        choosePanel.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        choosePanel.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        choosePanel.add((Component)okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        choosePanel.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        okButton.addActionListener(e -> this.performAction("refresh"));
        JPanel fieldPanel = new JPanel(new GridBagLayout());
        fieldPanel.add((Component)this.customerIdField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        fieldPanel.setBorder(new TitledBorder("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440"));
        this.activeTariffScrollPane.setBorder((Border)this.tariffBorder);
        this.activeTariffScrollPane.setMinimumSize(new Dimension(this.activeTariffScrollPane.getMinimumSize().width, 120));
        this.avaliableTariffList.setBorder((Border)new BGTitleBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b"));
        this.avaliableTariffList.setMinimumSize(new Dimension(this.activeTariffScrollPane.getMinimumSize().width, 120));
        JPanel customerDataPanel = new JPanel(new GridBagLayout());
        customerDataPanel.setBorder((Border)new BGTitleBorder("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435"));
        customerDataPanel.add((Component)fieldPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        customerDataPanel.add((Component)this.customerDataSaveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 5, 8, 5), 0, 0));
        customerDataPanel.add((Component)this.customerDataDeleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 5, 8, 5), 0, 0));
        customerDataPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        customerDataPanel.add((Component)this.activeTariffScrollPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        customerDataPanel.add((Component)this.avaliableTariffList, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.customerDataSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Utils.isBlankString((String)UserTransactionsPanel.this.customerIdField.getText())) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0439\u0442\u0435 \u043f\u0443\u0441\u0442\u044b\u043c \"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\" !", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    if (UserTransactionsPanel.this.pairData == null || !UserTransactionsPanel.this.pairData.isPair()) {
                        if (UserTransactionsPanel.this.pairData == null) {
                            UserTransactionsPanel.this.pairData = new VidimaxClientPairData();
                        }
                        UserTransactionsPanel.this.pairData.setCustomerId(UserTransactionsPanel.this.customerIdField.getText());
                        UserTransactionsPanel.this.pairData.setContractId(UserTransactionsPanel.this.contractId);
                        ArrayList<Integer> l = new ArrayList<Integer>();
                        int[] nArray = UserTransactionsPanel.this.avaliableTariffList.getSelectedIds();
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            Integer n2 = nArray[i];
                            l.add(n2);
                        }
                        UserTransactionsPanel.this.pairData.setFirstTariffIds(Utils.toString(l));
                        UserTransactionsPanel.this.service.updateClientPairData(UserTransactionsPanel.this.pairData);
                        UserTransactionsPanel.this.performAction("refresh");
                    }
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        this.customerDataDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u043d\u0438\u044e ?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
                        UserTransactionsPanel.this.service.deleteClientPairData(UserTransactionsPanel.this.contractId);
                        UserTransactionsPanel.this.performAction("refresh");
                    }
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(customerDataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(choosePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        LocalDate localDate = LocalDate.now().withDayOfMonth(1);
        this.periodPanel.setLocalDateFrom(localDate);
        this.periodPanel.setLocalDateTo(localDate.plusMonths(1L).minusDays(1L));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            try {
                this.serviceMap = this.service.serviceMap().getMap();
                this.tariffTitleMap = this.service.tariffMap().getMap();
                this.pairData = this.service.clientPairDataGet(this.contractId);
                this.activeTariffScrollPane.setVisible(this.pairData != null && this.pairData.isPair());
                if (this.pairData != null) {
                    this.customerIdField.setText(this.pairData.getCustomerId());
                    this.customerDataSaveButton.setEnabled(!this.pairData.isPair());
                    this.customerDataDeleteButton.setEnabled(!this.pairData.isPair());
                    this.customerIdField.setEnabled(!this.pairData.isPair());
                    if (this.pairData.isPair()) {
                        this.tariffBorder.setTitle(this.tariffBorder.getTitle() + " ( \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 ) ");
                        Async.of(() -> {
                            List data = this.service.activeTariffList(this.contractId, true);
                            data.addAll(this.service.activeTariffList(this.contractId, false));
                            List[] result = (List[])new Object[2];
                            result[0] = data;
                            this.tariffBorder.setTitle("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b");
                            this.tariffModel.setData(result[0]);
                            this.tariffTable.updateUI();
                        });
                    }
                } else {
                    this.customerDataDeleteButton.setEnabled(false);
                    this.customerIdField.setText("");
                }
                this.avaliableTariffList.setVisible(this.avaliableTariffList.getList().getModel().getSize() > 0);
            }
            catch (BGException ex) {
                this.activeTariffScrollPane.setVisible(false);
                this.avaliableTariffList.setVisible(false);
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.model.setData(this.service.chargeList(this.contractId, this.periodPanel.getPeriod(), null, null));
        });
    }

    private class ChargeModel
    extends BGTableModel<VidimaxCharge> {
        public ChargeModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430", 160, 160, 200, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 20, 90, 200, "sum", true);
            this.addColumn("id \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", 20, 130, 200, "operationId", true);
            this.addColumn("id \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430", 20, 130, 200, "customerId", true);
            this.addColumn("\u0422\u0430\u0440\u0438\u0444", 20, 160, 200, "tariffId", true);
            this.addColumn("\u0421\u0435\u0440\u0432\u0438\u0441", 20, 160, 200, "serviceTypeId", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", true);
        }

        public Object getValueAt(VidimaxCharge val, int column) throws BGException {
            if (column == 5) {
                String title = UserTransactionsPanel.this.tariffTitleMap.get(val.getTariffId());
                return title == null ? Integer.valueOf(val.getTariffId()) : title;
            }
            if (column == 6) {
                int sId = val.getServiceTypeId();
                return UserTransactionsPanel.this.serviceMap.get(sId) == null ? "" + sId : UserTransactionsPanel.this.serviceMap.get(sId).getTitle();
            }
            return super.getValueAt((Object)val, column);
        }
    }

    private class TariffModel
    extends BGTableModel<VidimaxTariff> {
        public TariffModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 160, 160, 300, "title", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 20, 70, 100, "sum", true);
            this.addColumn("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0442\u0430\u0440\u0438\u0444", 20, 100, 150, "primary", true);
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 20, 120, 150, "startCurrentPeriod", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 20, 120, 150, "stopCurrentPeriod", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435(\u043e\u0442\u043c\u0435\u043d\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438)", 20, 180, 200, "expirationDate", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "description", true);
        }
    }
}

