/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

public class TvOptionAddTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"fugue/tag-label");
    private JPanel editor;
    private BGComboBox<IdTitle> serviceCombo;
    private Directory serviceDir;
    private int optionId;
    private String optionTitle;
    private JLabel view;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.serviceDir = this.getDirManager().getDirectory("option");
    }

    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.editor.add(new JLabel("\u041e\u043f\u0446\u0438\u044f: "));
            this.serviceCombo = new BGComboBox();
            this.serviceCombo.addItem((Object)new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
            this.editor.add((Component)this.serviceCombo);
            int moduleId = this.getModuleId(this.getParent());
            ClientContext clientContext = new ClientContext("tv", moduleId, -1, null);
            try {
                JSONObject productSpecTree = ((ProductService)clientContext.getWebService(ProductService.class, 0)).productSpecTree(moduleId);
                ArrayList<IdTitle> items = new ArrayList<IdTitle>();
                this.buildList(productSpecTree, "", items);
                for (IdTitle di : items) {
                    this.serviceCombo.addItem((Object)di);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return this.editor;
    }

    private void buildList(JSONObject json, String title, List<IdTitle> items) {
        title = (String)title + (((String)title).length() > 0 ? " => " : "") + json.getString("title");
        JSONArray children = json.optJSONArray("children");
        if (children == null) {
            items.add(new IdTitle(json.getInt("id"), (String)title));
        } else {
            for (int index = 0; index < children.length(); ++index) {
                this.buildList(children.getJSONObject(index), (String)title, items);
            }
        }
    }

    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel();
            this.view.setIcon(icon);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder();
        if (this.optionId > 0) {
            sb.append("=> ");
            sb.append(this.optionTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.optionId = Utils.parseInt((String)((String)data.get("optionId")));
        this.optionTitle = this.serviceDir.getValue(this.optionId);
    }

    protected void loadData() {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox)this.serviceCombo, this.optionId);
    }

    protected void editOk() {
        this.optionId = this.getIdFromDirectoryCombo((JComboBox)this.serviceCombo);
        super.editOk();
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("optionId", String.valueOf(this.optionId));
        this.setDataInHash(data);
    }

    public void serializeToXML(Element el) {
        this.extractData();
        super.serializeToXML(el);
        el.setAttribute("optionId", String.valueOf(this.optionId));
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) {
        this.optionId = Utils.parseInt((String)el.getAttribute("optionId"));
        this.serializeData();
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

