/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionSuspendReason;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftlineProductDao;

public class Module
extends ModuleBase {
    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.softline.server"};
    }

    public void start(final Connection con, final BGModule module) throws BGException {
        super.start(con, module);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<Event>(){

            public void notify(Event event, EventListenerContext ctx) throws BGException {
                PaymentEvent paymentEvent = (PaymentEvent)event;
                SoftLineSubscriptionService subscriptionService = (SoftLineSubscriptionService)ctx.getService(SoftLineSubscriptionService.class, module.getId());
                List subscriptionList = subscriptionService.searchSubscriptions(null, null, paymentEvent.getContractId(), -1, SoftLineSubscriptionStatus.SUSPEND, -1).getList();
                subscriptionList.removeIf(sub -> sub.getSuspendReason() != SoftLineSubscriptionSuspendReason.FIN_BLOCK);
                try (SoftlineProductDao productDao = new SoftlineProductDao(con, module.getId());){
                    for (SoftLineSubscription subscription : subscriptionList) {
                        SoftLineProduct productOfSubscription;
                        if (!SoftLineUtils.checkActivation((Connection)con, (SoftLineSubscription)subscription, (SoftLineProduct)(productOfSubscription = (SoftLineProduct)productDao.get(subscription.getProductId())))) continue;
                        SoftLineUtils.prolongationDateEndSubscription((SoftLineSubscription)subscription, (SoftLineProduct)productOfSubscription);
                        subscriptionService.activateSubscription(subscription);
                    }
                }
            }
        }, PaymentEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<Event>(){

            public void notify(Event event, EventListenerContext ctx) throws BGException {
                ContractDeleteEvent contractDeleteEvent = (ContractDeleteEvent)event;
                if (!(contractDeleteEvent.isCheck() || module.getId() != contractDeleteEvent.getModuleId() && contractDeleteEvent.getModuleId() != 0)) {
                    SoftLineSubscriptionService subscriptionService = (SoftLineSubscriptionService)ctx.getService(SoftLineSubscriptionService.class, module.getId());
                    List subscriptions = subscriptionService.searchSubscriptions(null, null, event.getContractId(), -1, null, -1).getList();
                    Module.this.getLogger().info("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + event.getContractId());
                    for (SoftLineSubscription subscription : subscriptions) {
                        subscriptionService.deleteSubscription(subscription, true);
                    }
                }
            }
        }, ContractDeleteEvent.class);
    }
}

