/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.server.event.worker;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.sberbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.sberbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class SberbankCheckEventWorker
extends EventWorker {
    private long sleepTimeout = 300L;

    public SberbankCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), SberbankCheckEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.sleepTimeout = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getLong("sberbank.check.event.worker.sleep.timeout", 300L);
        this.getLogger().info("Starting SberbankCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "sberbank-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        SberbankCheckEvent event = (SberbankCheckEvent)((Object)task);
        try (TransactionManager transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);){
            if (event.getTransactionId() > 0) {
                Transaction transaction = (Transaction)transactionManager.get(event.getTransactionId());
                if (transaction != null) {
                    transactionManager.doCheckRequest(transaction);
                }
            } else {
                transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            }
        }
        try {
            Thread.sleep(this.sleepTimeout);
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex);
        }
        return null;
    }
}

