<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">
   <html>
   <head>
   <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
   </head>
    <body>
    <center>
        <xsl:call-template name="head"/><br/>
        <xsl:call-template name="table"/><br/>
        <xsl:call-template name="sums"/>
    </center>
    </body>
    </html>
</xsl:template>

<xsl:template name="head">
    <xsl:for-each select="/data/table">
         <h2><xsl:value-of select="@reportTitle"/><br/>
         Договор:&#160;<xsl:value-of select="@contractTitle"/>(<xsl:value-of select="@comment"/>)
         </h2><br/>
         Период с: <xsl:value-of select="@date1"/> по <xsl:value-of select="@date2"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="table">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">  
         <td>Пойнт</td>       
         <td>Услуга</td>
         <td>Количество сессий</td>
         <td>Время</td>
         <td>Время окр.</td>
         <td>Стоимость</td>
     </tr>
     <xsl:for-each select="/data/table/data/row">
         <tr bgcolor="#ffffff">
             <td><xsl:value-of select="@item"/></td>
             <td><xsl:value-of select="@dest"/></td>
             <td><xsl:value-of select="@number"/></td>
             <td><xsl:value-of select="@time"/></td>
             <td><xsl:value-of select="@time_round"/></td>
             <td><xsl:value-of select="@cost"/></td>
         </tr>
     </xsl:for-each>
</table>
</xsl:template>

<xsl:template name="sums">
    <br/>
	Количество сессий:&#160;<xsl:value-of select="/data/table/@total_number"/>&#160;
    Итого [в секундах]:&#160;<xsl:value-of select="/data/table/@total_time"/>&#160;
    Итого окр. [в секундах]:&#160;<xsl:value-of select="/data/table/@total_time_round"/>&#160;
    Итого [в рублях]:&#160;<xsl:value-of select="/data/table/@total_cost"/>&#160;
</xsl:template>

</xsl:stylesheet>
