/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.onpay.server.servlet;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.onpay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.onpay.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

@WebServlet(name="OnPayApi", urlPatterns={"/onpay/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(ModuleExecutor.class);
    private final Logger log = LogManager.getLogger();

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block41: {
            int moduleId = 0;
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            try {
                moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            }
            catch (BGMessageException ex) {
                this.log.error((Object)ex);
                response.sendError(500, ex.getMessage());
                return;
            }
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                Contract contract = this.getContract(con, request);
                String mode = request.getParameter("LMI_PREREQUEST");
                if (mode == null) {
                    mode = "0";
                }
                int paymentTypeId = moduleSetup.getInt("onpay.payment.type.id", -1);
                if ("0".equals(mode) && this.checkHash(request, moduleSetup)) {
                    int paymentId = -1;
                    Date now = new Date();
                    BigDecimal summa = new BigDecimal(request.getParameter("LMI_PAYMENT_AMOUNT"));
                    if (contract != null) {
                        Payment payment = Payment.builder().setDate(now).setContractId(contract.getId()).setTypeId(paymentTypeId).setSum(summa).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(request.getParameter("LMI_SYS_PAYMENT_ID")).setComment(moduleSetup.get("onpay.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 Onpay ({PAYMENT_SYSTEM}; {PAID_AMOUNT} {PAID_CURRENCY})").replace("{PAYMENT_SYSTEM}", request.getParameter("LMI_PAYMENT_SYSTEM")).replace("{PAID_AMOUNT}", request.getParameter("LMI_PAID_AMOUNT")).replace("{PAID_CURRENCY}", request.getParameter("LMI_PAID_CURRENCY"))).build();
                        try (PaymentDao paymentDao = new PaymentDao(con);
                             BalanceUtils bu = new BalanceUtils(con);){
                            paymentDao.update((Object)payment);
                            paymentId = payment.getId();
                            ServerUtils.commitConnection((Connection)con);
                            bu.updateBalance(payment.getDate(), contract);
                            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
                        }
                        catch (BGException ex) {
                            this.log.error((Object)ex);
                        }
                    }
                    try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                        StringBuilder data = new StringBuilder();
                        Enumeration enumeration = request.getParameterNames();
                        while (enumeration.hasMoreElements()) {
                            this.addParameter(data, request, (String)enumeration.nextElement());
                        }
                        transactionManager.update((Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contract != null ? contract.getId() : -1)).setTransactionId(request.getParameter("LMI_SYS_PAYMENT_ID"))).setTransactionDate(TimeUtils.parseDate((String)request.getParameter("LMI_SYS_PAYMENT_DATE"), (String)"yyyy-MM-dd'T'HH:mm:ss"))).setSum(summa)).setPaymentId(paymentId)).setCreateDate(now)).setSysPaymentData(data.toString()).build());
                    }
                    catch (BGException ex) {
                        this.log.error((Object)ex);
                    }
                    response.setContentType("text/plain;charset=UTF-8");
                    response.getWriter().print("OK");
                    response.flushBuffer();
                    break block41;
                }
                if ("1".equals(mode) || "2".equals(mode)) {
                    String responseText = "NO";
                    try {
                        if (contract != null && new ContractModuleManager(con).getContractModuleSet(contract.getId()).contains(moduleId) && TimeUtils.dateInRange((Date)new Date(), (Date)contract.getDateFrom(), (Date)contract.getDateTo()) && !contract.isHidden() && paymentTypeId > 0) {
                            responseText = "YES";
                        } else {
                            this.log.error("Contract = " + contract);
                            if (contract != null) {
                                this.log.error("Contract period = " + contract.getDateFrom() + " - " + contract.getDateTo() + " [" + new Date() + "]");
                                this.log.error("Contract modules ids = " + Utils.toString((Iterable)new ContractModuleManager(con).getContractModuleSet(contract.getId())) + " [moduleId=" + moduleId + "]");
                                this.log.error("PaymentTypeId = " + paymentTypeId);
                            }
                        }
                    }
                    catch (BGException e) {
                        this.log.error((Object)e);
                    }
                    response.setContentType("text/plain;charset=UTF-8");
                    response.getWriter().print(responseText);
                    response.flushBuffer();
                    break block41;
                }
                response.sendError(500, "Request parameter error!");
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private Contract getContract(Connection con, HttpServletRequest request) {
        Contract contract;
        ContractDao contractDao = new ContractDao(con, 0);
        try {
            Contract contract2 = contractDao.getByTitle(request.getParameter("LMI_PAYMENT_NO"));
            if (contract2 == null) {
                contract2 = (Contract)contractDao.get(Utils.parseInt((String)request.getParameter("contractId"), (int)0));
            }
            contract = contract2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    contractDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e) {
                e.printStackTrace();
                return null;
            }
        }
        contractDao.close();
        return contract;
    }

    private boolean checkHash(HttpServletRequest request, ModuleSetup moduleSetup) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getParameter(request, "LMI_MERCHANT_ID"));
        buf.append(this.getParameter(request, "LMI_PAYMENT_NO"));
        buf.append(this.getParameter(request, "LMI_SYS_PAYMENT_ID"));
        buf.append(this.getParameter(request, "LMI_SYS_PAYMENT_DATE"));
        buf.append(this.getParameter(request, "LMI_PAYMENT_AMOUNT"));
        buf.append(this.getParameter(request, "LMI_CURRENCY"));
        buf.append(this.getParameter(request, "LMI_PAID_AMOUNT"));
        buf.append(this.getParameter(request, "LMI_PAID_CURRENCY"));
        buf.append(this.getParameter(request, "LMI_PAYMENT_SYSTEM"));
        buf.append(this.getParameter(request, "LMI_SIM_MODE"));
        buf.append(moduleSetup.get("onpay.secret"));
        boolean result = false;
        try {
            MessageDigest digest = MessageDigest.getInstance(moduleSetup.get("onpay.digest.type", "SHA256"));
            digest.update(buf.toString().getBytes(StandardCharsets.UTF_8));
            String checkHash = new String(Base64.encode((byte[])digest.digest())).concat(";");
            result = checkHash.equals(this.getParameter(request, "LMI_HASH"));
            if (!result) {
                this.log.error("hash_str = " + buf.toString());
                this.log.error("hash_calc = " + checkHash);
                this.log.error("hash_query = " + this.getParameter(request, "LMI_HASH"));
            }
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    private String getParameter(HttpServletRequest request, String parameterName) {
        String result = request.getParameter(parameterName);
        return result != null ? result.concat(";") : ";";
    }

    private void addParameter(StringBuilder data, HttpServletRequest request, String parameterName) {
        data.append(parameterName);
        data.append("=");
        data.append(request.getParameter(parameterName));
        data.append("\n");
    }
}

