/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;

public class DayModeCostTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    private final BigDecimal cost;
    private final String costMode;
    private final int costType;
    private final int tariffVarId;

    public DayModeCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
        this.costType = parameterMap.getInt("type", 0);
        this.costMode = parameterMap.get("costMode", "const");
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
    }

    protected int executeImpl(Long treeNodeId, NPayTariffRequest tariffRequest, NPayTariffContext nPayTariffContext) {
        ContractTariffVar contractTariffVar;
        BigDecimal inCost = this.cost;
        if (tariffRequest.getServiceObject().getCost() != null) {
            inCost = tariffRequest.getServiceObject().getCost();
        } else if ("var".equals(this.costMode) && (contractTariffVar = tariffRequest.getContractTariffVar(this.tariffVarId)) != null) {
            String value = contractTariffVar.getValue();
            inCost = new BigDecimal(value == null ? contractTariffVar.getDefaultValue() : value);
        }
        inCost = switch (this.costType) {
            case 0 -> inCost;
            case 1 -> inCost.divide(BigDecimal.valueOf(tariffRequest.getAccountingMonthDays()), nPayTariffContext.mc);
            case 2 -> inCost.divide(BigDecimal.valueOf(30L), nPayTariffContext.mc);
            default -> inCost;
        };
        ((NPayServiceCost)tariffRequest.serviceCost).setCost(inCost);
        return 1;
    }
}

