/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.server.action.web.ActionOrders;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;

public class ActionCopyOrders
extends ActionOrders {
    @Override
    public void doAction() throws BGException {
        int selectedCopyId = this.req.getInt("copy", -1);
        int term = this.req.getInt("copyTerm", -1);
        if (term <= 0 || selectedCopyId <= 0) {
            this.setResultParam("error", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430.");
        } else if (this.newOrdersSelectedOnly() && this.buyOrdersSelectedOnly()) {
            LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
            int ordersCount = this.req.getInt("ordersCount", -1);
            for (int i = 1; i <= ordersCount; ++i) {
                int id = this.req.getInt("chbx_" + i, -1);
                Order order = licenseManager.getOrder(id);
                if (order == null) continue;
                ConfirmedOrder grouppedConfirmedItem = licenseManager.groupCopyItems(order.getComponentId(), order.getCopyId(), new int[]{2, 0});
                licenseManager.createTestCopiesForOrder(order, term, grouppedConfirmedItem.getCount());
            }
        } else {
            this.setResultParam("error", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\" \u0438 \u0442\u0438\u043f\u043e\u043c \"\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439\".");
        }
        super.doAction();
        this.setResultParam("action", "Orders");
    }

    private boolean newOrdersSelectedOnly() {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        boolean onlyNew = true;
        int ordersCount = this.req.getInt("ordersCount", -1);
        for (int i = 1; i <= ordersCount; ++i) {
            int id = this.req.getInt("chbx_" + i, -1);
            if (id <= 0 || licenseManager.getOrderStatus(id) == 0) continue;
            onlyNew = false;
            break;
        }
        return onlyNew;
    }

    private boolean buyOrdersSelectedOnly() {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        boolean buyOnly = true;
        int ordersCount = this.req.getInt("ordersCount", -1);
        for (int i = 1; i <= ordersCount; ++i) {
            int id = this.req.getInt("chbx_" + i, -1);
            if (id <= 0 || licenseManager.getOrderType(id) == OrderType.BUY.getCode()) continue;
            buyOnly = false;
            break;
        }
        return buyOnly;
    }
}

