/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;

public class PatternLabelAndGroupTabPanel
extends PatternBaseTabPanel {
    private ContractLabelTree contractLabelTree = new ContractLabelTree();

    public PatternLabelAndGroupTabPanel(Document moduleDoc) {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.contractLabelTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData(Document doc) {
        try {
            this.contractLabelTree.setData(this.getContext().getPort(ContractLabelService.class).getContractLabelTreeItemList(-1, false));
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setPatternData(ContractPattern contractPattern) {
        long groups = contractPattern.getGroups();
        HashSet<Integer> selectedLabelsInPattern = new HashSet<Integer>();
        for (int i = 0; i < 64; ++i) {
            if ((groups & 1L << i) <= 0L) continue;
            selectedLabelsInPattern.add(i + 2);
        }
        selectedLabelsInPattern.addAll(contractPattern.getContractLabels());
        this.contractLabelTree.setSelectedIds(selectedLabelsInPattern);
    }

    @Override
    public void resetData() {
        this.contractLabelTree.setSelectedIds(new ArrayList<Integer>());
    }

    @Override
    public boolean setRequestData(Request request) {
        List<Integer> selectedIds = this.contractLabelTree.getSelectedIds();
        if (selectedIds.stream().anyMatch(el -> el > 100)) {
            selectedIds.add(100);
        }
        String ids = selectedIds.stream().collect(() -> new StringBuilder(), (accumulator, element) -> accumulator.append(element).append(","), StringBuilder::append).toString();
        request.setAttribute("contractLabels", ids);
        return true;
    }
}

