/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.client;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class ExecuteOperatorTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon("link");
    private Directory dir;
    private int tariffTreeId;
    private String tariffTreeTitle;
    private JLabel view;
    private JPanel editor;
    private BGUComboBox<IdTitle> costMapCombo;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.dir = this.getDirManager().getDirectory("tariff");
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.tariffTreeId = Utils.parseInt(data.get("tariffTreeId"));
        this.tariffTreeTitle = this.dir.getValue(this.tariffTreeId);
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.costMapCombo = new BGUComboBox();
            this.editor = new JPanel();
            this.editor.add(this.costMapCombo);
            this.costMapCombo.setData(this.dir.getItems());
        }
        Map<String, String> data = this.getDataInHash();
        this.costMapCombo.setSelectedItem(Utils.parseInt(data.get("tariffTreeId")));
        return this.editor;
    }

    @Override
    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        this.view.setText("\u0422\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + this.tariffTreeTitle);
        return this.view;
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tariffTreeId", String.valueOf(((IdTitle)this.costMapCombo.getSelectedItem()).getId()));
        this.setDataInHash(data);
    }

    @Override
    public void loadFromXML(Element element) {
        this.loadHashFromXML(element);
    }

    @Override
    public void serializeToXML(Element element) {
        this.serializeHashToXML(element);
    }
}

