/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.MenuScroller;

public class BGMenuBar
extends JMenuBar {
    public void setData(Node menuBarNode) {
        this.removeAll();
        if (menuBarNode != null) {
            for (Element menu : XMLUtils.selectElements(menuBarNode, "menu")) {
                this.addMenu(null, menu);
            }
        }
    }

    private void addMenu(JMenu parentMenu, Element menu) {
        if (menu != null) {
            String title = menu.getAttribute("title");
            String id = menu.getAttribute("id");
            if (Utils.notEmptyString(title)) {
                JMenu jMenu = new JMenu(title);
                jMenu.setName(id);
                if (parentMenu == null) {
                    this.add(jMenu);
                } else {
                    parentMenu.add(jMenu);
                }
                if (menu.hasChildNodes()) {
                    for (Element menuItem : XMLUtils.elements(menu.getChildNodes())) {
                        String nodeName = menuItem.getNodeName();
                        if ("menuItem".equals(nodeName)) {
                            this.addMenuItem(jMenu, menuItem);
                            continue;
                        }
                        if ("separator".equals(nodeName)) {
                            jMenu.addSeparator();
                            continue;
                        }
                        if (!"menu".equals(nodeName)) continue;
                        this.addMenu(jMenu, menuItem);
                    }
                    if ("modules".equals(id)) {
                        int client_h = BGClientBase.getFrame().getHeight();
                        int item_h = BGMenuBar.getMenuItemHeight(jMenu);
                        int maxitems = (client_h - 20) / item_h;
                        if (jMenu.getItemCount() > maxitems) {
                            MenuScroller.setScrollerFor(jMenu, maxitems - 2 - 2, 125, 2, 0);
                        }
                    }
                }
            }
        }
    }

    private static int getMenuItemHeight(JMenu jMenu) {
        for (Component c : jMenu.getMenuComponents()) {
            if (!(c instanceof JMenuItem)) continue;
            return (int)((JMenuItem)c).getPreferredSize().getHeight();
        }
        return 20;
    }

    private void addMenuItem(JMenu jMenu, Element menuItem) {
        if (menuItem == null) {
            return;
        }
        String title = menuItem.getAttribute("title");
        if (Utils.isEmptyString(title)) {
            return;
        }
        String className = menuItem.getAttribute("className");
        Object name = menuItem.getAttribute("name");
        if (Utils.isEmptyString((String)name)) {
            name = title;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(menuItem.getAttribute("keyStroke"));
        int mid = Utils.parseInt(menuItem.getAttribute("mid"));
        int pos = ((String)name).indexOf(38);
        if (pos >= 0) {
            name = ((String)name).substring(0, pos) + ((String)name).substring(pos + 1);
        }
        Action action = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (Action.class.isAssignableFrom(clazz)) {
                action = clazz.asSubclass(Action.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            action = this.getActionMap().get(className);
        }
        String icon0 = menuItem.getAttribute("icon");
        ImageIcon icon = Utils.isEmptyString(icon0) ? null : ClientUtils.getIcon(icon0);
        if (action == null) {
            action = new MenuAction(className, title, (String)name, keyStroke, icon, mid);
        } else {
            action.putValue("Name", name);
            action.putValue("AcceleratorKey", keyStroke);
            action.putValue("item.name", title);
            action.putValue("item.mid", mid);
            if (icon != null) {
                action.putValue("SmallIcon", icon);
            }
        }
        if (pos >= 0 && pos < ((String)name).length()) {
            action.putValue("MnemonicKey", ((String)name).codePointAt(pos));
        } else {
            action.putValue("MnemonicKey", ((String)name).codePointAt(0));
        }
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenu.add(jMenuItem);
    }

    public class MenuAction
    extends BGUAction {
        public final String name;
        public final int moduleId;

        public MenuAction(String command, String name, String title, KeyStroke stroke, Icon icon, int moduleId) {
            super(command, title, stroke, icon);
            this.name = name;
            this.moduleId = moduleId;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String className = (String)this.getValue("ActionCommandKey");
            if (className == null) {
                return;
            }
            try {
                Class<?> clazz = Class.forName(className);
                boolean fl = false;
                try {
                    String TAB_ID = clazz.getSimpleName();
                    try {
                        TAB_ID = (String)clazz.getDeclaredField("TAB_ID").get(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BGClientBase.getFrame().getTabbedPane().addTab(TAB_ID, clazz.asSubclass(AbstractTabPanel.class));
                    fl = true;
                }
                catch (ClassCastException ex) {
                    fl = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    fl = false;
                }
                if (!fl) {
                    actionEvent.setSource(this);
                    clazz.asSubclass(ActionListener.class).getConstructor(new Class[0]).newInstance(new Object[0]).actionPerformed(actionEvent);
                }
            }
            catch (ClassNotFoundException ex) {
                ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430! \u041a\u043b\u0430\u0441\u0441 '" + className + "' - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430! " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }
}

