/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.stream.Stream;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.LookAndFeelUtils;
import ru.bitel.common.function.Async;

public class BGCalendarButton
extends JToggleButton
implements PropertyChangeListener,
PopupMenuListener {
    private Calendar oldDateCalendar;
    private int columns = 0;
    private int columnWidth = 0;
    private Calendar calendar;
    private DateFormat df = new SimpleDateFormat("dd.MM.yyyy");
    private static Async<Popup> popup = Async.uncompleted();
    private final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Keys key = Keys.getKeys(actionEvent.getActionCommand());
            LocalDate localDate = LocalDate.now();
            switch (key) {
                case DATE_PREV: 
                case DATE_NEXT: {
                    if (BGCalendarButton.this.calendar == null) break;
                    localDate = TimeUtils.convertDateToLocalDate(BGCalendarButton.this.calendar.getTime());
                    localDate = localDate.plusDays(key.getAmount());
                    break;
                }
                case MONTH_PREV: 
                case MONTH_NEXT: {
                    if (BGCalendarButton.this.calendar == null) break;
                    localDate = TimeUtils.convertDateToLocalDate(BGCalendarButton.this.calendar.getTime());
                    localDate = localDate.plusMonths(key.getAmount());
                    break;
                }
                case YEAR_PREV: 
                case YEAR_NEXT: {
                    if (BGCalendarButton.this.calendar == null) break;
                    localDate = TimeUtils.convertDateToLocalDate(BGCalendarButton.this.calendar.getTime());
                    localDate = localDate.plusYears(key.getAmount());
                    break;
                }
                case NOW: {
                    break;
                }
                case CLEAR: {
                    localDate = null;
                }
            }
            BGCalendarButton.this.setLocalDate(localDate);
            BGCalendarButton.this.repaint();
        }
    };

    public BGCalendarButton() {
        try {
            this.setMargin(new Insets(2, 5, 2, 5));
            this.setColumns(7);
            this.jbInit();
            this.setFocusPainted(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setActionCommand("popup");
        this.addActionListener(actionEvent -> this.setPopupVisible(true));
        ActionMap actionMap = this.getActionMap();
        this.putActionMap(Keys.NOW, actionMap);
        this.putActionMap(Keys.CLEAR, actionMap);
        this.putActionMap(Keys.DATE_NEXT, actionMap);
        this.putActionMap(Keys.DATE_PREV, actionMap);
        this.putActionMap(Keys.MONTH_NEXT, actionMap);
        this.putActionMap(Keys.MONTH_PREV, actionMap);
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(39, 128), Keys.DATE_NEXT.getKey());
        inputMap.put(KeyStroke.getKeyStroke(37, 128), Keys.DATE_PREV.getKey());
        inputMap.put(KeyStroke.getKeyStroke(38, 128), Keys.MONTH_NEXT.getKey());
        inputMap.put(KeyStroke.getKeyStroke(40, 128), Keys.MONTH_PREV.getKey());
        inputMap.put(KeyStroke.getKeyStroke(155, 128), Keys.NOW.getKey());
        inputMap.put(KeyStroke.getKeyStroke(127, 128), Keys.CLEAR.getKey());
    }

    private void putActionMap(Keys keys, ActionMap actionMap) {
        actionMap.put(keys.getKey(), new BGUAction(keys.getKey(), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGCalendarButton.this.actionListener.actionPerformed(actionEvent);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("updateCalendar".equals(propertyName)) {
            this.setPopupVisible(false);
            Calendar newCalendar = null;
            if (popup.get().getCalendar() != null) {
                newCalendar = (Calendar)popup.get().getCalendar().clone();
            }
            this.setLocalDate(TimeUtils.convertDateToLocalDate(newCalendar != null ? newCalendar.getTime() : null));
            this.firePropertyChange("popupVisible", true, false);
            this.firePropertyChange("updateCalendar", this.oldDateCalendar, newCalendar);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.getModel().setSelected(false);
        this.getModel().setPressed(false);
        BGCalendarButton.popup.get().calendarPanel.removePropertyChangeListener(this);
        popup.get().removePopupMenuListener(this);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        int oldVal = this.columns;
        if (columns != oldVal) {
            this.columns = columns;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            Calendar c;
            Calendar calendar = c = this.calendar != null ? this.calendar : new GregorianCalendar();
            if (popup.get().getCalendar() == null || !BGCalendarButton.dateEqual(c, popup.get().getCalendar())) {
                popup.get().setCalendar(c);
            }
            BGCalendarButton.popup.get().calendarPanel.addPropertyChangeListener(this);
            popup.get().addPopupMenuListener(this);
            popup.get().show(this, 0, this.getHeight() + 1);
            Component comp = BGCalendarButton.popup.get().calendarPanel.getDateField().getComponent(1);
            if (comp != null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().downFocusCycle();
                comp.requestFocus();
            }
        } else {
            popup.get().setVisible(false);
        }
    }

    public void setLocalDate(LocalDate localDate) {
        this.oldDateCalendar = this.calendar == null ? null : (Calendar)this.calendar.clone();
        this.setOnlyCalendar(localDate != null ? TimeUtils.convertLocalDateTimeToCalendar(localDate.atStartOfDay()) : null);
    }

    @Override
    public void setText(String text) {
        this.setLocalDate(TimeUtils.convertDateToLocalDate(TimeUtils.convertStringToDate(text)));
    }

    private void setOnlyCalendar(Calendar calendar) {
        Calendar calendar2 = this.calendar = calendar != null ? (Calendar)calendar.clone() : null;
        if (this.calendar != null) {
            super.setText(this.df.format(calendar.getTime()));
        } else {
            super.setText("");
        }
    }

    public void undoCalendar() {
        this.setOnlyCalendar(this.oldDateCalendar);
    }

    public void clearOldCalendar() {
        this.oldDateCalendar = null;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public LocalDate getLocalDate() {
        return this.calendar == null ? null : TimeUtils.convertDateToLocalDate(this.calendar.getTime());
    }

    @Override
    public String getText() {
        return this.calendar != null ? this.df.format(this.calendar.getTime()) : " ";
    }

    private static boolean dateEqual(Calendar date1, Calendar date2) {
        return date1.get(6) == date2.get(6) && date1.get(1) == date2.get(1) && date1.get(0) == date2.get(0);
    }

    static {
        SwingUtilities.invokeLater(() -> {
            Popup cp = null;
            try {
                cp = new Popup();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            final Popup popup = cp;
            popup.complete(popup);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lookAndFeel".equals(evt.getPropertyName())) {
                        SwingUtilities.updateComponentTreeUI(popup);
                    }
                }
            });
        });
    }

    static enum Keys {
        CLEAR("common.calendarButton.clear", 0),
        NOW("common.calendarButton.now", 0),
        YEAR_PREV("common.calendarButton.year.prev", -1),
        YEAR_NEXT("common.calendarButton.year.next", 1),
        MONTH_PREV("common.calendarButton.month.prev", -1),
        MONTH_NEXT("common.calendarButton.month.next", 1),
        DATE_PREV("common.calendarButton.date.prev", -1),
        DATE_NEXT("common.calendarButton.date.next", 1);

        private String key = "";
        private int amount;

        private Keys(String key, int amount) {
            this.key = key;
            this.amount = amount;
        }

        public String getKey() {
            return this.key;
        }

        public int getAmount() {
            return this.amount;
        }

        public static Keys getKeys(String key) {
            return Stream.of(Keys.values()).filter(a -> a.getKey().equals(key)).findFirst().orElse(null);
        }
    }

    private static class Popup
    extends JPopupMenu {
        private CalendarPanel calendarPanel = new CalendarPanel();

        public Popup() {
            try {
                this.calendarPanel.setVisibleLabelDate(false);
                this.calendarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.add("Center", this.calendarPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Calendar getCalendar() {
            return this.calendarPanel.getCalendar();
        }

        public void setCalendar(Calendar calendar) {
            this.calendarPanel.setCalendar(calendar);
        }
    }
}

