/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.xml.JAXBUtils;

public class ProductPeriod
extends Id {
    private static final long serialVersionUID = 1L;
    public static final int FLAG_SUSPENDED = 1;
    public static final int FLAG_SPLITTED = 2;
    public static final int FLAG_FINISHED = 4;
    public static final int FLAG_PROPORTIONAL = 8;
    private int productId;
    private int contractId;
    private int accountId;
    private int productSpecId;
    private Date activationTime;
    private Date timeFrom;
    private Date timeTo;
    private Date prolongationTime;
    private int flags;
    private int version;

    @XmlAttribute
    public int getProductId() {
        return this.productId;
    }

    public void setProductId(int productId) {
        this.productId = productId;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute
    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    @XmlAttribute
    public int getProductSpecId() {
        return this.productSpecId;
    }

    public void setProductSpecId(int specId) {
        this.productSpecId = specId;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(Date timeFrom) {
        this.timeFrom = timeFrom;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(Date timeTo) {
        this.timeTo = timeTo;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getProlongationTime() {
        return this.prolongationTime;
    }

    public void setProlongationTime(Date prolongationTime) {
        this.prolongationTime = prolongationTime;
    }

    @XmlAttribute
    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    @XmlAttribute
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"id\" : ");
        sb.append(this.getId());
        sb.append(", \"period\" : ");
        sb.append(TimeUtils.formatPeriodWithTime(this.timeFrom, this.timeTo));
        sb.append(" }");
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProductPeriod productPeriod) {
        return new Builder(productPeriod);
    }

    public static class Builder {
        private ProductPeriod productPeriod = null;

        private Builder() {
            this.productPeriod = new ProductPeriod();
        }

        private Builder(ProductPeriod productPeriod) {
            this.productPeriod = productPeriod;
        }

        public Builder setId(int id) {
            this.productPeriod.id = id;
            return this;
        }

        public Builder setProductId(int productId) {
            this.productPeriod.productId = productId;
            return this;
        }

        public Builder setContractId(int contractId) {
            this.productPeriod.contractId = contractId;
            return this;
        }

        public Builder setAccountId(int accountId) {
            this.productPeriod.accountId = accountId;
            return this;
        }

        public Builder setProductSpecId(int specId) {
            this.productPeriod.productSpecId = specId;
            return this;
        }

        public Builder setActivationTime(Date activationTime) {
            this.productPeriod.activationTime = activationTime;
            return this;
        }

        public Builder setTimeFrom(Date timeFrom) {
            this.productPeriod.timeFrom = timeFrom;
            return this;
        }

        public Builder setTimeTo(Date timeTo) {
            this.productPeriod.timeTo = timeTo;
            return this;
        }

        public Builder setProlongationTime(Date prolongationTime) {
            this.productPeriod.prolongationTime = prolongationTime;
            return this;
        }

        public Builder setFlags(int flags) {
            this.productPeriod.flags = flags;
            return this;
        }

        public Builder setVersion(int version) {
            this.productPeriod.version = version;
            return this;
        }

        public ProductPeriod build() {
            return this.productPeriod;
        }
    }
}

