/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.worker;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.worker.Commitable;
import ru.bitel.common.worker.Recyclable;
import ru.bitel.common.worker.ThreadContext;

public class WorkerThread<C extends ThreadContext>
extends Thread {
    protected final C context;
    private final String nestedContext;
    private static final Logger logger = LogManager.getLogger();

    public WorkerThread(ThreadGroup group, Runnable target, String name, long stackSize, String nestedContext, C context) {
        super(group, target, name, stackSize);
        this.context = context;
        this.nestedContext = nestedContext;
    }

    @Override
    public void run() {
        if (this.nestedContext != null) {
            BGNestedContext.push(this.nestedContext);
        }
        if (this.context != null) {
            ((ThreadContext)this.context).init();
        }
        Object parentContext = ThreadContext.get();
        ThreadContext.set(this.context);
        try {
            super.run();
            if (this.context instanceof Commitable) {
                ((Commitable)this.context).commit();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        finally {
            ThreadContext.set(parentContext);
            if (this.context instanceof Recyclable) {
                ((Recyclable)this.context).recycle();
            }
            if (this.context != null) {
                ((ThreadContext)this.context).destroy();
            }
            if (this.nestedContext != null) {
                BGNestedContext.pop();
            }
        }
    }
}

