/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.global.bean;

import bsh.BshMethod;
import bsh.Interpreter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.server.bean.GlobalScriptLogDao;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;

public class GlobalScriptMachine {
    private static final Logger log = LogManager.getLogger((String)"global.script");
    private ScriptInstance function;
    private ConnectionSet connectionSet;
    private static final Class<?>[] methodOnEventArgs = new Class[]{DefaultServerSetup.class, Connection.class, Connection.class};

    public GlobalScriptMachine(ScriptInstance function, ConnectionSet connectionSet) {
        this.function = function;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Creating script machine for function: " + function.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.connectionSet = connectionSet;
    }

    public Object runScript(DefaultServerSetup setup, boolean logProcess) {
        String result;
        block16: {
            result = null;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            PrintStream outPrintStream = new PrintStream(out);
            PrintStream errPrintStream = new PrintStream(err);
            StringBuilder warnings = new StringBuilder();
            StringWriter exceptions = new StringWriter();
            Connection con = this.connectionSet.getConnection();
            Connection conSlave = this.connectionSet.getSlaveConnection();
            GregorianCalendar startTime = new GregorianCalendar();
            try {
                try {
                    this.runScriptImpl(setup, con, conSlave, outPrintStream, errPrintStream);
                    ScriptInstance.DeprecatedCheker.checkOnDeprecated(this.function.getInterpreter(), this.function, warnings);
                }
                catch (Throwable ex) {
                    log.error("Eval error: " + ex.getMessage(), ex);
                    exceptions.append(ex.getMessage()).append("\n");
                    ex.printStackTrace(new PrintWriter(exceptions));
                }
                outPrintStream.flush();
                errPrintStream.flush();
                if (out.size() > 0) {
                    log.info(out.toString());
                }
                if (err.size() > 0) {
                    log.error(err.toString());
                }
                if (!logProcess) break block16;
                String tableName = ServerUtils.getMonthTableName("log_gscript_process", new GregorianCalendar().getTime());
                Connection trashCon = Setup.getSetup().getDBTrashOrMasterConnectionFromPool(tableName);
                try (GlobalScriptLogDao logDao = new GlobalScriptLogDao(trashCon, tableName);){
                    result = logDao.writeLog(this.function.getScript().getTitle(), out.toString(), err.toString(), exceptions.toString(), startTime);
                }
                catch (Exception e) {
                    throw new BGException((Throwable)e);
                }
                finally {
                    ServerUtils.closeConnection(trashCon);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    protected void runScriptImpl(DefaultServerSetup setup, Connection con, Connection conSlave, PrintStream outPrintStream, PrintStream errPrintStream) throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("setup", (Object)setup);
        vars.put("con", con);
        vars.put("conSlave", conSlave);
        this.function.eval(outPrintStream, errPrintStream, vars);
        Interpreter it = this.function.getInterpreter();
        BshMethod method = it.getNameSpace().getMethod("main", (Class[])methodOnEventArgs);
        if (method != null) {
            it.unset("setup");
            it.unset("con");
            it.unset("conSlave");
            this.function.invoke("main", new Object[]{setup, con, conSlave}, outPrintStream, errPrintStream);
        }
    }
}

