/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.ipn.client.editor.ManadContractRuleEditor;
import ru.bitel.bgbilling.modules.ipn.common.CiscoRuleOptions;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class CiscoContractRuleEditor
extends ManadContractRuleEditor {
    private String aclCode = "";
    private BGTextField fromPos;
    private DefaultListModel<BGUListItem> model = new DefaultListModel();
    private JList<BGUListItem> aclList = new JList<BGUListItem>(this.model);

    @Override
    protected JPanel getCommandPanel() {
        this.fromPos = new BGTextField();
        this.fromPos.setEnabled(false);
        JPanel aclPanel = new JPanel(new GridBagLayout());
        aclPanel.add((Component)new JLabel("\u0421 \u043f\u043e\u0437\u0438\u0446\u0438\u0438:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        aclPanel.add((Component)this.fromPos, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        aclPanel.add((Component)new JLabel("ACL \u0441\u043f\u0438\u0441\u043e\u043a:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        aclPanel.add((Component)new JScrollPane(this.aclList), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        JTabbedPane ruleAndIfacePanel = new JTabbedPane();
        JScrollPane ruleScroll = new JScrollPane(this.rule_TA);
        ruleAndIfacePanel.add("ACL", aclPanel);
        JPanel cmdPanel = new JPanel(new GridBagLayout());
        cmdPanel.add((Component)ruleScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        ruleAndIfacePanel.add("\u041a\u043e\u043c\u0430\u043d\u0434\u044b", cmdPanel);
        JPanel result = new JPanel(new BorderLayout());
        result.add(ruleAndIfacePanel);
        return result;
    }

    @Override
    public void setData() {
        super.setData();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("CiscoAclList");
        request.setModuleId(this.getModuleId());
        request.setAttribute("gate", this.gateId);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList(this.aclList, this.model, (Node)XMLUtils.getElement((Document)doc, (String)"list"));
        }
        ClientUtils.setListSelection(this.aclList, (String)this.aclCode);
    }

    @Override
    protected String getRule(String rule) {
        CiscoRuleOptions ruleOptions = CiscoRuleOptions.extractParams((String)rule);
        rule = CiscoRuleOptions.clearFromParams((String)rule);
        this.aclCode = String.valueOf(ruleOptions.aclId);
        this.fromPos.setText(String.valueOf(ruleOptions.fromPos));
        return rule;
    }

    @Override
    protected String addUpdateParams(String rule) {
        int acl = Utils.parseInt((String)ClientUtils.getIdFromList(this.aclList));
        if (acl <= 0) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ACL!");
            return null;
        }
        CiscoRuleOptions ruleOptions = new CiscoRuleOptions();
        ruleOptions.aclId = acl;
        ruleOptions.fromPos = Utils.parseInt((String)this.fromPos.getText());
        rule = CiscoRuleOptions.addParams((String)rule, (CiscoRuleOptions)ruleOptions);
        return rule;
    }

    @Override
    protected String getUpdateAction() {
        return "UpdateCiscoContractRule";
    }

    @Override
    protected String getGenerateAction() {
        return "GenerateRule";
    }
}

